/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.repository;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem;
import com.xebialabs.deployit.repository.ChangeSet;
import com.xebialabs.deployit.repository.RepositoryService;
import com.xebialabs.xlrelease.builder.LinkBuilder;
import com.xebialabs.xlrelease.domain.ActivityLogEntry;
import com.xebialabs.xlrelease.domain.Link;
import com.xebialabs.xlrelease.domain.ParallelGroup;
import com.xebialabs.xlrelease.domain.ReleaseActivity;
import com.xebialabs.xlrelease.domain.Task;
import com.xebialabs.xlrelease.repository.AbstractRepository;
import com.xebialabs.xlrelease.repository.ActivityLog;
import com.xebialabs.xlrelease.repository.Ids;
import com.xebialabs.xlrelease.user.User;
import java.util.ArrayList;
import java.util.Objects;
import java.util.Set;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;

@Repository
public class Links
extends AbstractRepository {
    private ActivityLog activityLog;

    @Autowired
    public Links(RepositoryService repositoryService, ActivityLog activityLog) {
        super(repositoryService);
        this.activityLog = activityLog;
    }

    @Override
    protected String getEntityPrefix() {
        return "Link";
    }

    public Link create(String containerId, String sourceId, String targetId) {
        Task container = (Task)this.repositoryService.read(containerId);
        Task source = (Task)this.repositoryService.read(sourceId);
        Task target = (Task)this.repositoryService.read(targetId);
        Link link = LinkBuilder.newLink().withId(this.getUniqueId(containerId)).withSource(source).withTarget(target).build();
        Preconditions.checkArgument((boolean)(container instanceof ParallelGroup), (Object)"You can't add a link to a container that's not a parallel group.");
        Preconditions.checkState((!container.hasBeenStarted() ? 1 : 0) != 0, (Object)"You can't add a link to a container that has already been started.");
        Preconditions.checkState((boolean)this.uniqueLinkWithinContainer(container, link), (Object)"You can't add the same link twice within a parallel group.");
        Preconditions.checkArgument((boolean)source.getContainer().equals((Object)container), (Object)"You can't add a link whose source isn't a direct child of the container.");
        Preconditions.checkArgument((boolean)target.getContainer().equals((Object)container), (Object)"You can't add a link whose target isn't a direct child of the container.");
        this.repositoryService.create((ConfigurationItem[])new Link[]{link});
        this.activityLog.log(Ids.releaseIdFrom(containerId), ReleaseActivity.LINK_ADDED.create(container.getTitle(), source.getTitle(), target.getTitle()));
        return link;
    }

    public void delete(String linkId) {
        boolean isTargetNeedUpdate;
        Link link = (Link)this.repositoryService.read(linkId);
        ParallelGroup parallelGroup = link.getParallelGroup();
        Preconditions.checkState((!parallelGroup.hasBeenStarted() ? 1 : 0) != 0, (Object)"Can't remove a link from a container that has already been started");
        Task target = link.getTarget();
        ChangeSet changeSet = new ChangeSet();
        changeSet.delete((ConfigurationItem)link);
        ArrayList logEntries = Lists.newArrayList((Object[])new ActivityLogEntry[]{ReleaseActivity.LINK_REMOVED.create(parallelGroup.getTitle(), link.getSource().getTitle(), link.getTarget().getTitle())});
        boolean bl = isTargetNeedUpdate = !target.isWaitForScheduledStartDate();
        if (isTargetNeedUpdate) {
            target.setWaitForScheduledStartDate(true);
            changeSet.update((ConfigurationItem)target);
            logEntries.add(ReleaseActivity.TASK_WAIT_FOR_SCHEDULED_START_DATE_UPDATED.create(target.getTitle(), target.isWaitForScheduledStartDate()));
        }
        this.repositoryService.execute(changeSet);
        this.activityLog.log(Ids.releaseIdFrom(parallelGroup.getId()), logEntries, User.AUTHENTICATED_USER);
    }

    private boolean uniqueLinkWithinContainer(Task container, Link newLink) {
        Set<Link> links = ((ParallelGroup)container).getLinks();
        for (Link link : links) {
            if (!Objects.equals((Object)newLink.getSource(), (Object)link.getSource()) || !Objects.equals((Object)newLink.getTarget(), (Object)link.getTarget())) continue;
            return false;
        }
        return true;
    }
}

