/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.repository;

import com.google.common.collect.Lists;
import com.xebialabs.deployit.jcr.JcrCallback;
import com.xebialabs.deployit.jcr.JcrTemplate;
import com.xebialabs.xlrelease.views.TimeFrame;
import java.util.ArrayList;
import java.util.List;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.query.Query;
import javax.jcr.query.QueryManager;
import javax.jcr.query.QueryResult;
import javax.jcr.query.Row;
import javax.jcr.query.RowIterator;

public abstract class JcrQueryExecutorForList<T> {
    private JcrTemplate jcrTemplate;
    private TimeFrame since;

    public JcrQueryExecutorForList(JcrTemplate jcrTemplate, TimeFrame since) {
        this.jcrTemplate = jcrTemplate;
        this.since = since;
    }

    public abstract String query(TimeFrame var1);

    public abstract T transform(Row var1) throws RepositoryException;

    public List<T> getList() {
        return (List)this.jcrTemplate.execute(new JcrCallback<List<T>>(){

            public List<T> doInJcr(Session session) throws RepositoryException {
                QueryManager qm = session.getWorkspace().getQueryManager();
                Query query = qm.createQuery(JcrQueryExecutorForList.this.query(JcrQueryExecutorForList.this.since), "JCR-SQL2");
                QueryResult queryResult = query.execute();
                ArrayList result = Lists.newArrayList();
                RowIterator rowIterator = queryResult.getRows();
                while (rowIterator.hasNext()) {
                    Row row = rowIterator.nextRow();
                    result.add(JcrQueryExecutorForList.this.transform(row));
                }
                return result;
            }
        });
    }
}

