/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.repository;

import com.xebialabs.deployit.plugin.api.reflect.Type;
import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem;
import com.xebialabs.deployit.plugin.api.udm.Metadata;
import com.xebialabs.deployit.repository.RepositoryService;
import com.xebialabs.deployit.repository.SearchParameters;
import com.xebialabs.deployit.repository.core.Directory;
import com.xebialabs.xlrelease.configuration.DeployitServerDefinition;
import com.xebialabs.xlrelease.repository.AbstractRepository;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;

@Repository
public class DeployitServers
extends AbstractRepository {
    protected static final String SERVER_PREFIX = "Server";
    protected static final String ROOT = Metadata.ConfigurationItemRoot.CONFIGURATION.getRootNodeName() + "/Deployit";

    @Autowired
    public DeployitServers(RepositoryService repositoryService) {
        super(repositoryService);
    }

    @Override
    protected String getEntityPrefix() {
        return SERVER_PREFIX;
    }

    public List<DeployitServerDefinition> getServers() {
        SearchParameters query = new SearchParameters().setType(Type.valueOf(DeployitServerDefinition.class)).setParent(ROOT);
        return this.repositoryService.listEntities(query);
    }

    public DeployitServerDefinition addServer(DeployitServerDefinition deployitServerDefinition) {
        if (!this.repositoryService.exists(ROOT)) {
            Directory directory = new Directory();
            directory.setId(ROOT);
            this.repositoryService.create((ConfigurationItem[])new Directory[]{directory});
        }
        this.repositoryService.create((ConfigurationItem[])new DeployitServerDefinition[]{deployitServerDefinition});
        return deployitServerDefinition;
    }

    public void deleteServer(String id) {
        this.repositoryService.delete(new String[]{id});
    }

    public DeployitServerDefinition updateServer(String serverId, DeployitServerDefinition server) {
        if (serverId.equals(server.getId())) {
            this.repositoryService.update((ConfigurationItem[])new DeployitServerDefinition[]{server});
        } else {
            this.repositoryService.rename(serverId, server.getName());
            this.repositoryService.update((ConfigurationItem[])new DeployitServerDefinition[]{server});
        }
        return server;
    }

    public DeployitServerDefinition findById(String serverId) {
        return (DeployitServerDefinition)this.repositoryService.read(serverId);
    }
}

