/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.reports;

import com.xebialabs.xlrelease.reports.AverageByMonthComputer;
import com.xebialabs.xlrelease.reports.ReleaseDuration;
import com.xebialabs.xlrelease.reports.ReleasesDuration;
import com.xebialabs.xlrelease.reports.TopSorter;
import java.util.Comparator;
import java.util.List;
import org.joda.time.DateTime;

public class ReleasesDurationComputer {
    private ReleasesDuration releasesDuration = new ReleasesDuration();
    private List<ReleaseDuration> releasesDurationData;
    private AverageByMonthComputer averageComputer;

    public ReleasesDurationComputer(List<ReleaseDuration> releasesDurationData) {
        this.releasesDurationData = releasesDurationData;
        if (releasesDurationData.size() > 0) {
            DateTime startDate = releasesDurationData.get(0).getEndDate();
            this.averageComputer = new AverageByMonthComputer(startDate);
        }
    }

    public ReleasesDuration get() {
        if (this.releasesDurationData.size() > 0) {
            for (ReleaseDuration releaseDuration : this.releasesDurationData) {
                this.averageComputer.add(releaseDuration.getEndDate(), releaseDuration.getDuration());
            }
            DateTime endDate = this.releasesDurationData.get(this.releasesDurationData.size() - 1).getEndDate();
            this.releasesDuration.setAverage(this.averageComputer.completeSerie(endDate));
            this.releasesDuration.setLongestReleases(new TopSorter<ReleaseDuration>(this.releasesDurationData, 100).with(new Comparator<ReleaseDuration>(){

                @Override
                public int compare(ReleaseDuration r1, ReleaseDuration r2) {
                    return Long.compare(r2.getDuration(), r1.getDuration());
                }
            }));
        }
        return this.releasesDuration;
    }
}

