/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.reports;

import com.xebialabs.xlrelease.reports.AverageByMonthComputer;
import com.xebialabs.xlrelease.reports.ReleaseAutomationData;
import com.xebialabs.xlrelease.reports.ReleaseEfficiency;
import com.xebialabs.xlrelease.reports.ReleasesAutomation;
import java.util.List;
import org.joda.time.DateTime;

public class ReleaseAutomationComputer {
    private List<ReleaseAutomationData> releasesAutomationData;
    private AverageByMonthComputer averageAutomationComputer;
    private ReleasesAutomation releasesAutomation = new ReleasesAutomation();
    private ReleaseEfficiency releaseEfficiency = new ReleaseEfficiency();

    public ReleaseAutomationComputer(List<ReleaseAutomationData> releasesAutomationData) {
        this.releasesAutomationData = releasesAutomationData;
        if (releasesAutomationData.size() > 0) {
            DateTime startDate = releasesAutomationData.get(0).getEndDate();
            this.averageAutomationComputer = new AverageByMonthComputer(startDate);
        }
    }

    public ReleasesAutomation get() {
        if (this.releasesAutomationData.size() > 0) {
            for (ReleaseAutomationData releaseAutomationData : this.releasesAutomationData) {
                float automationPercentage = this.computePercentage(releaseAutomationData.getNumberOfAutomatedTasks(), releaseAutomationData.getNumberOfTasks());
                this.averageAutomationComputer.add(releaseAutomationData.getEndDate(), automationPercentage);
                this.releaseEfficiency.addTasksCount(releaseAutomationData);
                this.releaseEfficiency.addTasksDuration(releaseAutomationData);
            }
            DateTime endDate = this.releasesAutomationData.get(this.releasesAutomationData.size() - 1).getEndDate();
            this.releasesAutomation.setAverageAutomationPercentage(this.averageAutomationComputer.completeSerie(endDate));
        }
        this.releasesAutomation.setReleaseEfficiency(this.releaseEfficiency);
        return this.releasesAutomation;
    }

    private float computePercentage(float number, float total) {
        return number / total * 100.0f;
    }
}

