/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.notification;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.xebialabs.deployit.plumbing.scheduler.Scheduler;
import com.xebialabs.deployit.repository.RepositoryService;
import com.xebialabs.xlrelease.configuration.SmtpServer;
import com.xebialabs.xlrelease.notification.EmailFactory;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import javax.mail.internet.AddressException;
import javax.mail.internet.InternetAddress;
import org.apache.commons.mail.Email;
import org.apache.commons.mail.EmailException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class EmailSender {
    private static final Logger logger = LoggerFactory.getLogger(EmailSender.class);
    private EmailFactory emailFactory;
    private RepositoryService repositoryService;
    private Scheduler scheduler;

    @Autowired
    public EmailSender(RepositoryService repositoryService, EmailFactory emailFactory, Scheduler scheduler) {
        this.emailFactory = emailFactory;
        this.repositoryService = repositoryService;
        this.scheduler = scheduler;
    }

    public void scheduleEmail(final Collection<String> recipients, final String subject, final String body) {
        if (recipients == null) {
            logger.warn("Email with subject '%s' not sent, because the recipient is missing.", (Object)subject);
        }
        this.scheduler.execute(new Runnable(){

            @Override
            public void run() {
                try {
                    EmailSender.this.send(Sets.newHashSet((Iterable)recipients), subject, body);
                }
                catch (Exception e) {
                    logger.error("Could not send email ", (Throwable)e);
                }
            }
        });
    }

    public void scheduleEmail(final Collection<String> recipients, final String subject, final String body, final Runnable onSuccess, final Runnable onFailure) {
        this.scheduler.execute(new Runnable(){

            @Override
            public void run() {
                try {
                    EmailSender.this.send(recipients, subject, body);
                    onSuccess.run();
                }
                catch (Exception e) {
                    logger.error("Could not send email ", (Throwable)e);
                    onFailure.run();
                }
            }
        });
    }

    protected void send(Collection<String> recipients, String subject, String body) throws EmailException {
        SmtpServer smtpServer = (SmtpServer)this.repositoryService.read("Configuration/mail/SmtpServer");
        Email email = this.emailFactory.newEmail(smtpServer);
        this.setRecipients(email, recipients);
        this.setFrom(email, smtpServer.getFromAddress());
        email.setSubject(subject);
        email.setMsg(body);
        email.send();
    }

    @VisibleForTesting
    void setRecipients(Email email, Collection<String> recipients) throws EmailException {
        email.setTo(EmailSender.toInternetAddresses(recipients));
    }

    private static List<InternetAddress> toInternetAddresses(Collection<String> recipients) throws EmailException {
        ArrayList addresses = Lists.newArrayList();
        for (String recipient : recipients) {
            try {
                addresses.addAll(Arrays.asList(InternetAddress.parse((String)recipient)));
            }
            catch (AddressException e) {
                throw new EmailException((Throwable)e);
            }
        }
        return addresses;
    }

    @VisibleForTesting
    void setFrom(Email email, String fromAddress) throws EmailException {
        if (fromAddress == null) {
            return;
        }
        try {
            InternetAddress from = new InternetAddress(fromAddress);
            email.setFrom(from.getAddress(), from.getPersonal());
        }
        catch (AddressException e) {
            throw new EmailException((Throwable)e);
        }
    }
}

