/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.filters;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.base.Strings;
import com.google.common.collect.Collections2;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.xebialabs.deployit.security.Role;
import com.xebialabs.xlrelease.domain.ParallelGroup;
import com.xebialabs.xlrelease.domain.Release;
import com.xebialabs.xlrelease.domain.Task;
import com.xebialabs.xlrelease.filters.DateFilter;
import com.xebialabs.xlrelease.repository.UserProfiles;
import com.xebialabs.xlrelease.views.TasksFilters;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class TaskFilter {
    private boolean active;
    private boolean assignedToMe;
    private boolean assignedToMyTeams;
    private boolean assignedToOthers;
    private boolean notAssigned;
    private String filter;
    private UserProfiles userProfiles;
    private DateFilter dateFilter;

    public TaskFilter(TasksFilters tasksFilters, UserProfiles userProfiles) {
        this.active = tasksFilters.isActive();
        this.assignedToMe = tasksFilters.isAssignedToMe();
        this.assignedToMyTeams = tasksFilters.isAssignedToMyTeams();
        this.assignedToOthers = tasksFilters.isAssignedToOthers();
        this.notAssigned = tasksFilters.isNotAssigned();
        this.filter = tasksFilters.getFilter();
        this.dateFilter = new DateFilter(tasksFilters.getFrom(), tasksFilters.getTo());
        this.userProfiles = userProfiles;
    }

    @VisibleForTesting
    TaskFilter(boolean active, boolean assignedToMe, boolean assignedToMyTeams, boolean assignedToOthers, boolean notAssigned, String filter, Date from, Date to, UserProfiles userProfiles) {
        this.active = active;
        this.assignedToMe = assignedToMe;
        this.assignedToMyTeams = assignedToMyTeams;
        this.assignedToOthers = assignedToOthers;
        this.notAssigned = notAssigned;
        this.filter = filter;
        this.dateFilter = new DateFilter(from, to);
        this.userProfiles = userProfiles;
    }

    public List<Task> filter(String username, List<Role> userRoles, List<Release> releases) {
        ArrayList tasks = Lists.newArrayList();
        for (Release release : releases) {
            Set<String> teams = release.getTeamsOf(username, userRoles);
            tasks.addAll(this.filterWithTeams(username, teams, release.getAllTasks()));
        }
        return tasks;
    }

    @VisibleForTesting
    List<Task> filterWithTeams(String username, Set<String> teams, List<Task> tasks) {
        Preconditions.checkArgument((username != null ? 1 : 0) != 0, (Object)"Username must not be null.");
        Predicate matchesAssignment = Predicates.or((Predicate[])new Predicate[]{this.isAssignedToUserPredicate(username), this.isAssignedToTeamsPredicate(teams), this.isAssignedToOthersPredicate(username, teams), this.isNotAssignedPredicate()});
        Predicate matchesFilterQuery = Predicates.or((Predicate[])new Predicate[]{this.matchesTitle(), this.matchesOwner(), this.matchesOwnerFullname(), this.matchesTeam(), this.matchesRelease()});
        return Lists.newArrayList((Iterable)Collections2.filter(tasks, (Predicate)Predicates.and((Predicate[])new Predicate[]{Predicates.not((Predicate)Predicates.instanceOf(ParallelGroup.class)), this.isActivePredicate(), matchesAssignment, matchesFilterQuery, this.dateFilter.getPredicate()})));
    }

    private Predicate<Task> isActivePredicate() {
        return new Predicate<Task>(){

            public boolean apply(Task task) {
                return TaskFilter.this.active ? task.isActive() : !task.isDone() && !task.isDoneInAdvance();
            }
        };
    }

    private Predicate<Task> isAssignedToUserPredicate(final String username) {
        return new Predicate<Task>(){

            public boolean apply(Task task) {
                return TaskFilter.this.assignedToMe && username.equals(task.getOwner());
            }
        };
    }

    private Predicate<Task> isAssignedToTeamsPredicate(final Set<String> teams) {
        return new Predicate<Task>(){

            public boolean apply(Task task) {
                return TaskFilter.this.assignedToMyTeams && teams.contains(task.getTeam());
            }
        };
    }

    private Predicate<Task> isAssignedToOthersPredicate(final String username, final Set<String> teams) {
        return new Predicate<Task>(){

            public boolean apply(Task task) {
                boolean hasAssignment = task.hasOwner() || task.hasTeam();
                boolean hasDifferentOwner = !task.hasOwner() || !username.equals(task.getOwner());
                boolean hasDifferentTeam = !task.hasTeam() || !teams.contains(task.getTeam());
                return TaskFilter.this.assignedToOthers && hasAssignment && hasDifferentOwner && hasDifferentTeam;
            }
        };
    }

    private Predicate<Task> isNotAssignedPredicate() {
        return new Predicate<Task>(){

            public boolean apply(Task task) {
                return TaskFilter.this.notAssigned && !task.hasOwner() && !task.hasTeam();
            }
        };
    }

    private Predicate<Task> matchesTitle() {
        return new Predicate<Task>(){

            public boolean apply(Task task) {
                return TaskFilter.this.matchesText(task, task.getTitle());
            }
        };
    }

    private Predicate<Task> matchesOwner() {
        return new Predicate<Task>(){

            public boolean apply(Task task) {
                return TaskFilter.this.matchesText(task, task.getOwner());
            }
        };
    }

    private Predicate<Task> matchesOwnerFullname() {
        return new Predicate<Task>(){

            public boolean apply(Task task) {
                return TaskFilter.this.matchesText(task, TaskFilter.this.userProfiles.getFullName(task.getOwner()));
            }
        };
    }

    private Predicate<Task> matchesTeam() {
        return new Predicate<Task>(){

            public boolean apply(Task task) {
                return TaskFilter.this.matchesText(task, task.getTeam());
            }
        };
    }

    private Predicate<Task> matchesRelease() {
        return new Predicate<Task>(){

            public boolean apply(Task task) {
                return TaskFilter.this.matchesText(task, task.getRelease().getTitle());
            }
        };
    }

    private boolean matchesText(Task task, String text) {
        if (Strings.isNullOrEmpty((String)this.filter)) {
            return true;
        }
        Map<String, String> variables = task.getRelease().getVariableValues();
        String interpolatedText = Strings.nullToEmpty((String)task.replaceAll(text, variables, Sets.newHashSet(), false));
        return interpolatedText.toLowerCase().contains(this.filter.toLowerCase());
    }
}

