/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.export;

import com.google.common.base.Function;
import com.google.common.collect.Collections2;
import com.google.common.collect.Lists;
import com.xebialabs.xlrelease.export.TemplateImportUpgrade;
import com.xebialabs.xlrelease.export.TemplateImportUpgrader;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import javax.annotation.PostConstruct;
import nl.javadude.scannit.Scannit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.stereotype.Component;

@Component
public class TemplateImportUpgradesProvider {
    private ApplicationContext applicationContext;
    private List<TemplateImportUpgrade> upgrades;
    private static final Logger logger = LoggerFactory.getLogger(TemplateImportUpgrader.class);

    @Autowired
    public TemplateImportUpgradesProvider(ApplicationContext applicationContext) {
        this.applicationContext = applicationContext;
    }

    @PostConstruct
    public void init() {
        Set templateExportUpgrades = Scannit.getInstance().getSubTypesOf(TemplateImportUpgrade.class);
        logger.debug("Found the following upgraders: [{}]", (Object)templateExportUpgrades);
        this.upgrades = Lists.newArrayList((Iterable)Collections2.transform((Collection)templateExportUpgrades, (Function)new Function<Class<? extends TemplateImportUpgrade>, TemplateImportUpgrade>(){

            public TemplateImportUpgrade apply(Class<? extends TemplateImportUpgrade> input) {
                return (TemplateImportUpgrade)TemplateImportUpgradesProvider.this.applicationContext.getAutowireCapableBeanFactory().createBean(input);
            }
        }));
    }

    public List<TemplateImportUpgrade> getUpgrades() {
        return Lists.newArrayList(this.upgrades);
    }
}

