/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.export;

import com.google.common.base.Preconditions;
import com.google.common.base.Throwables;
import com.google.common.collect.ComparisonChain;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.xebialabs.deployit.plugin.api.reflect.PropertyDescriptor;
import com.xebialabs.deployit.plugin.api.reflect.Type;
import com.xebialabs.deployit.plumbing.CurrentVersion;
import com.xebialabs.deployit.server.api.upgrade.Version;
import com.xebialabs.xlrelease.domain.CustomScriptTask;
import com.xebialabs.xlrelease.domain.FlagStatus;
import com.xebialabs.xlrelease.domain.Task;
import com.xebialabs.xlrelease.export.TemplateImportUpgrade;
import com.xebialabs.xlrelease.export.TemplateImportUpgradesProvider;
import com.xebialabs.xlrelease.export.TemplateJsonHelper;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.codehaus.jettison.json.JSONException;
import org.codehaus.jettison.json.JSONObject;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class TemplateImportUpgrader {
    public static final String DEV_VERSION = "@project.version@";
    private TemplateImportUpgradesProvider templateImportUpgradesProvider;
    private Set<String> defaultProperties = Collections.unmodifiableSet(Sets.newHashSet((Object[])new String[]{"id", "type"}));

    @Autowired
    public TemplateImportUpgrader(TemplateImportUpgradesProvider templateImportUpgradesProvider) {
        this.templateImportUpgradesProvider = templateImportUpgradesProvider;
    }

    public List<String> upgrade(JSONObject release, String packageVersionId) {
        try {
            ArrayList warnings = Lists.newArrayList();
            this.resetUnknownTasks(release, warnings);
            if (packageVersionId.equals(DEV_VERSION)) {
                return warnings;
            }
            if (!CurrentVersion.get().equals(DEV_VERSION)) {
                Version currentVersion = this.getVersion(CurrentVersion.get());
                Version packageVersion = this.getVersion(packageVersionId);
                Preconditions.checkArgument((packageVersion.compareTo(currentVersion) <= 0 ? 1 : 0) != 0, (Object)String.format("Unsupported package version : '%s'", packageVersionId));
            }
            Version packageVersion = this.getVersion(packageVersionId);
            List<TemplateImportUpgrade> upgrades = this.templateImportUpgradesProvider.getUpgrades();
            this.sortUpgrades(upgrades);
            for (TemplateImportUpgrade upgrade : upgrades) {
                if (upgrade.getUpgradeVersion().compareTo(packageVersion) <= 0) continue;
                warnings.addAll(upgrade.performUpgrade(release));
            }
            return warnings;
        }
        catch (JSONException e) {
            throw Throwables.propagate((Throwable)e);
        }
    }

    private Version getVersion(String packageVersionId) {
        return Version.valueOf((String)"xl-release", (String)packageVersionId);
    }

    private void resetUnknownTasks(JSONObject release, List<String> warnings) throws JSONException {
        List<JSONObject> tasksFromRelease = TemplateJsonHelper.getTasksFromRelease(release);
        for (JSONObject task : tasksFromRelease) {
            JSONObject pythonScript;
            if (!this.isCustomScriptTask(task) || !this.typeNotFound(pythonScript = task.getJSONObject("pythonScript"))) continue;
            this.resetToManualTask(task);
            JSONObject phase = TemplateJsonHelper.getPhase(task, release);
            String warningMessage = String.format("Task '%s' in Phase '%s' has been replaced by a manual task. The task of type '%s' could not be found because of a missing plugin.", task.getString("title"), phase.get("title"), pythonScript.getString("type"));
            this.flagTask(task, warningMessage);
            warnings.add(warningMessage);
        }
    }

    private boolean isCustomScriptTask(JSONObject task) throws JSONException {
        return task.getString("type").equals(Type.valueOf(CustomScriptTask.class).toString());
    }

    private boolean typeNotFound(JSONObject pythonScript) throws JSONException {
        return !Type.valueOf((String)pythonScript.getString("type")).exists();
    }

    private void resetToManualTask(JSONObject task) throws JSONException {
        Type manualTaskType = Type.valueOf(Task.class);
        task.put("type", (Object)manualTaskType.toString());
        HashSet propertiesOnManualTask = Sets.newHashSet();
        for (PropertyDescriptor propertyDescriptor : manualTaskType.getDescriptor().getPropertyDescriptors()) {
            propertiesOnManualTask.add(propertyDescriptor.getName());
        }
        HashSet propertiesOnUnknownTask = Sets.newHashSet();
        Iterator i = task.keys();
        while (i.hasNext()) {
            propertiesOnUnknownTask.add((String)i.next());
        }
        for (String property : propertiesOnUnknownTask) {
            if (propertiesOnManualTask.contains(property) || this.defaultProperties.contains(property)) continue;
            task.remove(property);
        }
    }

    private void flagTask(JSONObject task, String warningMessage) throws JSONException {
        task.put("flagStatus", (Object)FlagStatus.ATTENTION_NEEDED);
        task.put("flagComment", (Object)warningMessage);
    }

    private void sortUpgrades(List<TemplateImportUpgrade> upgrades) {
        Collections.sort(upgrades, new Comparator<TemplateImportUpgrade>(){

            @Override
            public int compare(TemplateImportUpgrade o1, TemplateImportUpgrade o2) {
                return ComparisonChain.start().compare((Comparable)o1.getUpgradeVersion(), (Comparable)o2.getUpgradeVersion()).result();
            }
        });
    }
}

