/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.excel;

import com.xebialabs.xlrelease.domain.FlagStatus;
import com.xebialabs.xlrelease.domain.ParallelGroup;
import com.xebialabs.xlrelease.domain.Phase;
import com.xebialabs.xlrelease.domain.PlanItem;
import com.xebialabs.xlrelease.domain.Release;
import com.xebialabs.xlrelease.domain.Task;
import com.xebialabs.xlrelease.excel.Export;
import java.awt.Color;
import java.util.HashMap;
import java.util.HashSet;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.FillPatternType;
import org.apache.poi.ss.usermodel.Font;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.util.CellUtil;
import org.apache.poi.xssf.usermodel.XSSFCell;
import org.apache.poi.xssf.usermodel.XSSFCellStyle;
import org.apache.poi.xssf.usermodel.XSSFColor;
import org.apache.poi.xssf.usermodel.XSSFFont;
import org.apache.poi.xssf.usermodel.XSSFRow;

public class ReleaseExcel
extends Export {
    public static final int TITLE_COLUMN = 0;
    public static final int TASK_TYPE_COLUMN = 1;
    public static final int STATUS_COLUMN = 2;
    public static final int SCHEDULED_START_DATE_COLUMN = 3;
    public static final int DUE_DATE_COLUMN = 4;
    public static final int START_DATE_COLUMN = 5;
    public static final int END_DATE_COLUMN = 6;
    public static final int ASSIGNEE_COLUMN = 7;
    public static final int TEAM_COLUMN = 8;
    public static final int FLAG_COMMENT_COLUMN = 9;
    private static final String SCHEDULED_START_DATE_HEADER = "Scheduled start date";
    private static final String DUE_DATE_HEADER = "Due date";
    private static final String START_DATE_HEADER = "Start date";
    private static final String END_DATE_HEADER = "End date";
    private static final String ASSIGNEE_HEADER = "Assignee";
    private static final String TEAM_HEADER = "Team";
    private static final String FLAG_COMMENT_HEADER = "Status comment";
    private static final String DEFAULT_PHASE_COLOR = "#009CDB";
    private Release release;
    private boolean isPhaseRow = false;
    private boolean isReleaseRow = false;
    private XSSFCellStyle phaseStyle;
    private XSSFCellStyle dateStyle;

    public ReleaseExcel(Release release) {
        this.release = release;
    }

    @Override
    protected void addContent() {
        this.dateStyle = this.workBook.createCellStyle();
        this.dateStyle.setDataFormat(this.workBook.createDataFormat().getFormat("dd-MM-yy hh:mm"));
        this.addReleaseRow();
        for (Phase phase : this.release.getPhases()) {
            this.addPhaseRow(phase);
            for (Task task : phase.getAllTasks()) {
                this.addTaskRow(task);
            }
        }
    }

    @Override
    protected void setColumnsWidth() {
        this.sheet.setColumnWidth(0, this.numberOfCharacter(30));
        this.sheet.setColumnWidth(1, this.numberOfCharacter(15));
        this.sheet.setColumnWidth(2, this.numberOfCharacter(15));
        this.sheet.setColumnWidth(3, this.numberOfCharacter(16));
        this.sheet.setColumnWidth(4, this.numberOfCharacter(15));
        this.sheet.setColumnWidth(5, this.numberOfCharacter(15));
        this.sheet.setColumnWidth(6, this.numberOfCharacter(15));
        this.sheet.setColumnWidth(7, this.numberOfCharacter(15));
        this.sheet.setColumnWidth(8, this.numberOfCharacter(15));
        this.sheet.setColumnWidth(9, this.numberOfCharacter(20));
    }

    @Override
    protected void addHeaderRow() {
        XSSFRow row = this.sheet.createRow(this.rowIndex++);
        CellUtil.createCell((Row)row, (int)3, (String)SCHEDULED_START_DATE_HEADER);
        CellUtil.createCell((Row)row, (int)4, (String)DUE_DATE_HEADER);
        CellUtil.createCell((Row)row, (int)5, (String)START_DATE_HEADER);
        CellUtil.createCell((Row)row, (int)6, (String)END_DATE_HEADER);
        CellUtil.createCell((Row)row, (int)7, (String)ASSIGNEE_HEADER);
        CellUtil.createCell((Row)row, (int)8, (String)TEAM_HEADER);
        CellUtil.createCell((Row)row, (int)9, (String)FLAG_COMMENT_HEADER);
        this.sheet.createRow(this.rowIndex++);
    }

    private void addReleaseRow() {
        this.isReleaseRow = true;
        XSSFRow row = this.sheet.createRow(this.rowIndex++);
        this.addTitleCell(this.release, row);
        CellUtil.createCell((Row)row, (int)2, (String)this.release.getStatus().toString(), (CellStyle)this.getStyle(false, null));
        this.addScheduledStartDateCell(this.release, row);
        this.addDueDateCell(this.release, row);
        this.addStartDateCell(this.release, row);
        this.addEndDateCell(this.release, row);
        this.addFlagCommentCell(this.release, row);
        this.isReleaseRow = false;
        this.sheet.createRow(this.rowIndex++);
    }

    private void addPhaseRow(Phase phase) {
        this.isPhaseRow = true;
        XSSFRow row = this.sheet.createRow(this.rowIndex++);
        this.applyPhaseColorToRow(phase, row);
        this.addTitleCell(phase, row);
        CellUtil.createCell((Row)row, (int)2, (String)phase.getStatus().toString(), (CellStyle)this.getStyle(false, null));
        this.addScheduledStartDateCell(phase, row);
        this.addDueDateCell(phase, row);
        this.addStartDateCell(phase, row);
        this.addEndDateCell(phase, row);
        this.isPhaseRow = false;
    }

    private void addTaskRow(Task task) {
        XSSFRow row = this.sheet.createRow(this.rowIndex++);
        this.addTitleCell(task, row);
        CellUtil.createCell((Row)row, (int)1, (String)this.getTaskType(task), (CellStyle)this.getStyle(false, null));
        CellUtil.createCell((Row)row, (int)2, (String)task.getStatus().toString(), (CellStyle)this.getStyle(false, null));
        this.addScheduledStartDateCell(task, row);
        this.addDueDateCell(task, row);
        this.addStartDateCell(task, row);
        this.addEndDateCell(task, row);
        this.addAssigneeCell(task, row);
        this.addTeamCell(task, row);
        this.addFlagCommentCell(task, row);
    }

    private void applyPhaseColorToRow(Phase phase, XSSFRow row) {
        String phaseColor = phase.getColor();
        this.phaseStyle = this.workBook.createCellStyle();
        if (phaseColor == null) {
            phaseColor = DEFAULT_PHASE_COLOR;
        }
        Color color = Color.decode(phaseColor).brighter().brighter();
        this.phaseStyle.setFillForegroundColor(new XSSFColor(color));
        this.phaseStyle.setFillPattern(FillPatternType.SOLID_FOREGROUND);
        row.setRowStyle((CellStyle)this.phaseStyle);
    }

    private void addTitleCell(Task task, XSSFRow row) {
        String title = task.getTitle();
        PlanItem container = task.getContainer();
        while (container instanceof ParallelGroup) {
            title = container.getTitle() + " / " + title;
            container = ((ParallelGroup)container).getContainer();
        }
        this.addTitleCell(task, title, row);
    }

    private void addTitleCell(PlanItem item, XSSFRow row) {
        this.addTitleCell(item, item.getTitle(), row);
    }

    private void addTitleCell(PlanItem item, String title, XSSFRow row) {
        title = item.replaceAll(title, this.release.getVariableValues(), new HashSet<String>(), false);
        CellUtil.createCell((Row)row, (int)0, (String)title, (CellStyle)this.getStyle(false, null));
    }

    private void addScheduledStartDateCell(PlanItem item, XSSFRow row) {
        if (null != item.getScheduledStartDate()) {
            XSSFCell startDateCell = row.createCell(3);
            startDateCell.setCellValue(item.getScheduledStartDate());
            startDateCell.setCellStyle((CellStyle)this.getStyle(true, null));
        }
    }

    private void addDueDateCell(PlanItem item, XSSFRow row) {
        if (null != item.getDueDate()) {
            XSSFCell endDateCell = row.createCell(4);
            endDateCell.setCellValue(item.getDueDate());
            endDateCell.setCellStyle((CellStyle)this.getStyle(true, null));
        }
    }

    private void addStartDateCell(PlanItem item, XSSFRow row) {
        if (null != item.getStartDate()) {
            XSSFCell startDateCell = row.createCell(5);
            startDateCell.setCellValue(item.getStartDate());
            startDateCell.setCellStyle((CellStyle)this.getStyle(true, null));
        }
    }

    private void addEndDateCell(PlanItem item, XSSFRow row) {
        if (null != item.getEndDate()) {
            XSSFCell endDateCell = row.createCell(6);
            endDateCell.setCellValue(item.getEndDate());
            endDateCell.setCellStyle((CellStyle)this.getStyle(true, null));
        }
    }

    private void addAssigneeCell(Task task, XSSFRow row) {
        CellUtil.createCell((Row)row, (int)7, (String)task.getOwner(), (CellStyle)this.getStyle(false, null));
    }

    private void addTeamCell(Task task, XSSFRow row) {
        CellUtil.createCell((Row)row, (int)8, (String)task.getTeam(), (CellStyle)this.getStyle(false, null));
    }

    private void addFlagCommentCell(PlanItem item, XSSFRow row) {
        if (item.getFlagStatus() == FlagStatus.OK) {
            return;
        }
        XSSFColor backgroundColor = null;
        if (item.getFlagStatus() == FlagStatus.ATTENTION_NEEDED) {
            backgroundColor = new XSSFColor(Color.ORANGE);
        } else if (item.getFlagStatus() == FlagStatus.AT_RISK) {
            backgroundColor = new XSSFColor(Color.RED);
        }
        CellUtil.createCell((Row)row, (int)9, (String)item.getFlagComment(), (CellStyle)this.getStyle(false, backgroundColor));
    }

    private XSSFCellStyle getStyle(boolean isDate, XSSFColor backgroundColor) {
        XSSFCellStyle cellStyle = this.workBook.createCellStyle();
        if (isDate) {
            cellStyle.setDataFormat(this.dateStyle.getDataFormat());
        }
        if (backgroundColor != null) {
            cellStyle.setFillForegroundColor(backgroundColor);
            cellStyle.setFillPattern(FillPatternType.SOLID_FOREGROUND);
        } else if (this.isPhaseRow) {
            cellStyle.setFillForegroundColor(this.phaseStyle.getFillForegroundXSSFColor());
            cellStyle.setFillPattern(this.phaseStyle.getFillPattern());
        }
        if (this.isReleaseRow) {
            XSSFFont font = this.workBook.createFont();
            font.setBoldweight((short)700);
            cellStyle.setFont((Font)font);
        }
        return cellStyle;
    }

    private String getTaskType(Task task) {
        HashMap<String, String> types = new HashMap<String, String>(){
            {
                this.put("Task", "Manual");
                this.put("GateTask", "Gate");
                this.put("ParallelGroup", "Group");
                this.put("ScriptTask", "Script");
                this.put("NotificationTask", "Notification");
                this.put("DeployitTask", "Deployit");
                this.put("CustomScriptTask", "Custom script");
            }
        };
        String typeName = task.getType().getName();
        return types.containsKey(typeName) ? (String)types.get(typeName) : typeName;
    }
}

