/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.domain;

import com.google.common.base.Strings;
import com.google.common.collect.Sets;
import com.xebialabs.deployit.plugin.api.reflect.PropertyDescriptor;
import com.xebialabs.xlrelease.domain.CustomScriptTask;
import com.xebialabs.xlrelease.domain.DeployitTask;
import com.xebialabs.xlrelease.domain.GateCondition;
import com.xebialabs.xlrelease.domain.GateTask;
import com.xebialabs.xlrelease.domain.NotificationTask;
import com.xebialabs.xlrelease.domain.ParallelGroup;
import com.xebialabs.xlrelease.domain.Phase;
import com.xebialabs.xlrelease.domain.PythonScript;
import com.xebialabs.xlrelease.domain.Release;
import com.xebialabs.xlrelease.domain.ReleaseVisitor;
import com.xebialabs.xlrelease.domain.ScriptTask;
import com.xebialabs.xlrelease.domain.Task;
import com.xebialabs.xlrelease.domain.Variable;
import java.util.Set;

public class VariableCollectingVisitor
extends ReleaseVisitor {
    private final Set<Variable> variables = Sets.newTreeSet();

    public Set<Variable> result() {
        return this.variables;
    }

    private void collectVariables(String input, Variable.VariableType variableType) {
        if (Strings.isNullOrEmpty((String)input)) {
            return;
        }
        for (String variableName : Variable.collectVariables(input)) {
            this.variables.add(new Variable(variableName, variableType));
        }
    }

    private void collectVariables(String input) {
        this.collectVariables(input, Variable.VariableType.DEFAULT);
    }

    @Override
    public void visit(Release release) {
        this.collectVariables(release.getDescription());
    }

    @Override
    public void visit(Phase phase) {
        this.collectVariables(phase.getTitle());
        this.collectVariables(phase.getDescription());
    }

    @Override
    public void visit(Task task) {
        this.collectVariables(task.getTitle());
        this.collectVariables(task.getDescription());
        this.collectVariables(task.getOwner());
    }

    @Override
    public void visit(ParallelGroup group) {
    }

    @Override
    public void visit(GateTask task) {
        for (GateCondition condition : task.getConditions()) {
            this.collectVariables(condition.getTitle());
        }
    }

    @Override
    public void visit(DeployitTask task) {
        this.collectVariablesWithTypeWhenAlone(task.getDeploymentPackage(), Variable.VariableType.DEPLOYIT_PACKAGE);
        this.collectVariablesWithTypeWhenAlone(task.getEnvironment(), Variable.VariableType.DEPLOYIT_ENVIRONMENT);
        this.collectVariables(task.getUsername());
    }

    @Override
    public void visit(NotificationTask task) {
        for (String address : task.getAddresses()) {
            this.collectVariables(address);
        }
        this.collectVariables(task.getSubject());
        this.collectVariables(task.getBody());
    }

    @Override
    public void visit(ScriptTask task) {
        this.collectVariables(task.getScript());
    }

    @Override
    public void visit(CustomScriptTask customScriptTask) {
        PythonScript pythonScript = customScriptTask.getPythonScript();
        for (PropertyDescriptor propertyDescriptor : pythonScript.getPropertiesWithVariables()) {
            this.collectVariables((String)pythonScript.getProperty(propertyDescriptor.getName()));
        }
        for (PropertyDescriptor propertyDescriptor : pythonScript.getOutputProperties()) {
            String propertyName = propertyDescriptor.getName();
            this.collectVariablesWithTypeWhenAlone((String)pythonScript.getProperty(propertyName), Variable.VariableType.SCRIPT_RESULT);
        }
    }

    private void collectVariablesWithTypeWhenAlone(String input, Variable.VariableType type) {
        if (Strings.isNullOrEmpty((String)input)) {
            return;
        }
        if (Variable.containOnlyVariable(input)) {
            this.collectVariables(input, type);
        } else {
            this.collectVariables(input, Variable.VariableType.DEFAULT);
        }
    }
}

