/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.domain;

import com.xebialabs.deployit.plugin.api.udm.Property;
import com.xebialabs.deployit.plugin.api.udm.base.BaseConfigurationItem;
import com.xebialabs.deployit.security.Role;
import java.util.ArrayList;
import java.util.List;

public class Team
extends BaseConfigurationItem {
    public static final String TEMPLATE_OWNER_TEAMNAME = "Template Owner";
    public static final String RELEASE_ADMIN_TEAMNAME = "Release Admin";
    @Property
    private String teamName;
    @Property(required=false)
    private List<String> members = new ArrayList<String>();
    @Property(required=false)
    private List<String> roles = new ArrayList<String>();
    @Property(required=false)
    private List<String> permissions = new ArrayList<String>();

    public String getTeamName() {
        return this.teamName;
    }

    public void setTeamName(String teamName) {
        this.teamName = teamName;
    }

    public boolean hasMember(String username) {
        return this.members.contains(username);
    }

    public boolean hasPermission(String permission) {
        return this.permissions.contains(permission);
    }

    public List<String> getMembers() {
        return this.members;
    }

    public void setMembers(List<String> members) {
        this.members = members;
    }

    public void addMember(String newMember) {
        for (String member : this.members) {
            if (!member.equals(newMember)) continue;
            return;
        }
        this.members.add(newMember);
    }

    public List<String> getRoles() {
        return this.roles;
    }

    public void setRoles(List<String> roles) {
        this.roles = roles;
    }

    public void addRole(String newRole) {
        for (String role : this.roles) {
            if (!role.equals(newRole)) continue;
            return;
        }
        this.roles.add(newRole);
    }

    public boolean hasRole(String role) {
        return this.roles.contains(role);
    }

    public boolean hasAnyRole(List<Role> roles) {
        for (Role role : roles) {
            if (!this.hasRole(role.getName())) continue;
            return true;
        }
        return false;
    }

    public List<String> getPermissions() {
        return this.permissions;
    }

    public void setPermissions(List<String> permissions) {
        this.permissions = permissions;
    }

    public boolean isSystemTeam() {
        return RELEASE_ADMIN_TEAMNAME.equals(this.teamName) || TEMPLATE_OWNER_TEAMNAME.equals(this.teamName);
    }
}

