/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.domain;

public enum ReleaseStatus {
    TEMPLATE("template"),
    PLANNED("planned"),
    IN_PROGRESS("in_progress"),
    PAUSED("paused"),
    FAILING("failing"),
    FAILED("failed"),
    COMPLETED("completed"),
    ABORTED("aborted");

    public static final ReleaseStatus[] ACTIVE_STATUSES;
    private final String value;

    private ReleaseStatus(String v) {
        this.value = v;
    }

    public String value() {
        return this.value;
    }

    public static ReleaseStatus fromValue(String v) {
        for (ReleaseStatus c : ReleaseStatus.values()) {
            if (!c.value.equals(v)) continue;
            return c;
        }
        throw new IllegalArgumentException(v);
    }

    public boolean isActive() {
        for (ReleaseStatus active : ACTIVE_STATUSES) {
            if (this != active) continue;
            return true;
        }
        return false;
    }

    public boolean hasBeenStarted() {
        return this != TEMPLATE && this != PLANNED;
    }

    static {
        ACTIVE_STATUSES = new ReleaseStatus[]{IN_PROGRESS, FAILED, FAILING, PAUSED};
    }
}

