/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.domain;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.Collections2;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.google.common.io.CharStreams;
import com.xebialabs.deployit.plugin.api.reflect.PropertyDescriptor;
import com.xebialabs.deployit.plugin.api.reflect.PropertyKind;
import com.xebialabs.deployit.plugin.api.reflect.Type;
import com.xebialabs.deployit.plugin.api.udm.Property;
import com.xebialabs.deployit.plugin.api.udm.base.BaseConfigurationItem;
import com.xebialabs.xlrelease.domain.CustomScriptTask;
import com.xebialabs.xlrelease.domain.PythonScriptDefinition;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Collection;
import java.util.HashSet;

public class PythonScript
extends BaseConfigurationItem {
    @Property(required=false, hidden=false, asContainment=true)
    private CustomScriptTask customScriptTask;
    public static final Predicate<PropertyDescriptor> IS_INPUT_PROPERTY = Predicates.and((Predicate[])new Predicate[]{PythonScript.byCategory("input"), PythonScript.isVisible(), PythonScript.ofKind(PropertyKind.BOOLEAN, PropertyKind.INTEGER, PropertyKind.STRING, PropertyKind.CI)});
    public static final Predicate<PropertyDescriptor> IS_OUTPUT_PROPERTY = Predicates.and((Predicate[])new Predicate[]{PythonScript.byCategory("output"), PythonScript.isVisible(), PythonScript.notAPassword(), PythonScript.ofKind(PropertyKind.STRING)});
    public static final String SCRIPT_LOCATION_PROPERTY = "scriptLocation";
    public static final Type AS_TYPE = Type.valueOf(PythonScript.class);
    public static final String PYTHON_SCRIPT_ID = "PythonScript";

    public static boolean isScriptDefinition(Type type) {
        return type.getDescriptor().isAssignableTo(PythonScript.class);
    }

    public static Predicate<PropertyDescriptor> notAPassword() {
        return new Predicate<PropertyDescriptor>(){

            public boolean apply(PropertyDescriptor input) {
                return !input.isPassword();
            }
        };
    }

    public static Predicate<PropertyDescriptor> ofKind(PropertyKind ... propertyKinds) {
        final HashSet propertyKindSet = Sets.newHashSet((Iterable)Lists.newArrayList((Object[])propertyKinds));
        return new Predicate<PropertyDescriptor>(){

            public boolean apply(PropertyDescriptor input) {
                return propertyKindSet.contains(input.getKind());
            }
        };
    }

    private static Predicate<PropertyDescriptor> byCategory(final String category) {
        return new Predicate<PropertyDescriptor>(){

            public boolean apply(PropertyDescriptor property) {
                return category.equals(property.getCategory());
            }
        };
    }

    private static Predicate<PropertyDescriptor> isVisible() {
        return new Predicate<PropertyDescriptor>(){

            public boolean apply(PropertyDescriptor input) {
                return !input.isHidden();
            }
        };
    }

    public Collection<PropertyDescriptor> getPropertiesWithVariables() {
        PythonScriptDefinition scriptDefinition = new PythonScriptDefinition(this.getType());
        return Collections2.filter(scriptDefinition.getInputProperties(), (Predicate)Predicates.and(PythonScript.ofKind(PropertyKind.STRING), PythonScript.notAPassword()));
    }

    public Collection<PropertyDescriptor> getInputProperties() {
        return new PythonScriptDefinition(this.getType()).getInputProperties();
    }

    public Collection<PropertyDescriptor> getOutputProperties() {
        return new PythonScriptDefinition(this.getType()).getOutputProperties();
    }

    public String getScript() throws IOException {
        if (this.getProperty(SCRIPT_LOCATION_PROPERTY).equals("")) {
            String defaultPath = this.getDefaultPath();
            return this.readScript(defaultPath);
        }
        return this.readScript((String)this.getProperty(SCRIPT_LOCATION_PROPERTY));
    }

    private String getDefaultPath() {
        Type type = this.getType();
        String prefix = type.getPrefix();
        String name = type.getName();
        return prefix + "/" + name + ".py";
    }

    private String readScript(String path) throws IOException {
        try (InputStream stream = Thread.currentThread().getContextClassLoader().getResourceAsStream(path);){
            if (null == stream) {
                throw new FileNotFoundException("Can't find script in class-path under : " + path);
            }
            String string = CharStreams.toString((Readable)new InputStreamReader(stream, "UTF-8"));
            return string;
        }
    }

    public CustomScriptTask getCustomScriptTask() {
        return this.customScriptTask;
    }

    public void setCustomScriptTask(CustomScriptTask customScriptTask) {
        this.customScriptTask = customScriptTask;
    }

    public String getIconLocation() {
        return (String)this.getProperty("iconLocation");
    }

    public String getOutputVarHelpText() {
        return (String)this.getProperty("outputVarHelpText");
    }

    public String getTaskColor() {
        return (String)this.getProperty("taskColor");
    }
}

