/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.domain;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.ComparisonChain;
import com.google.common.primitives.Ints;
import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem;
import com.xebialabs.deployit.plugin.api.udm.Property;
import com.xebialabs.deployit.plugin.api.udm.base.BaseConfigurationItem;
import com.xebialabs.xlrelease.domain.Changes;
import com.xebialabs.xlrelease.domain.FlagStatus;
import com.xebialabs.xlrelease.domain.Release;
import com.xebialabs.xlrelease.domain.ReleaseVisitor;
import com.xebialabs.xlrelease.domain.Task;
import com.xebialabs.xlrelease.domain.Variable;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.joda.time.DateTime;

public abstract class PlanItem
extends BaseConfigurationItem {
    @Property
    private String title;
    @Property(required=false)
    private String description;
    @Property(required=false)
    private String owner;
    @Property(required=false)
    private Date scheduledStartDate;
    @Property(required=false)
    private Date dueDate;
    @Property(required=false)
    private Date startDate;
    @Property(required=false)
    private Date endDate;
    @Property(required=false)
    private Integer plannedDuration;
    @Property
    private FlagStatus flagStatus = FlagStatus.OK;
    @Property(required=false)
    private String flagComment;
    public static final Comparator<PlanItem> BY_TITLE = new Comparator<PlanItem>(){

        @Override
        public int compare(PlanItem left, PlanItem right) {
            String leftTitle = Strings.nullToEmpty((String)left.getTitle());
            String rightTitle = Strings.nullToEmpty((String)right.getTitle());
            return ComparisonChain.start().compare((Comparable)((Object)leftTitle), (Comparable)((Object)rightTitle)).result();
        }
    };

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String value) {
        this.description = value;
    }

    public String getOwner() {
        return this.owner;
    }

    public void setOwner(String value) {
        this.owner = value;
    }

    public boolean hasOwner() {
        return this.owner != null;
    }

    public boolean hasOwner(String releaseOwner) {
        return this.getOwner() != null && this.getOwner().equals(releaseOwner);
    }

    public Date getDueDate() {
        return this.dueDate;
    }

    public void setDueDate(Date value) {
        this.dueDate = value;
    }

    public Date getStartDate() {
        return this.startDate;
    }

    public void setStartDate(Date value) {
        this.startDate = value;
    }

    public Date getScheduledStartDate() {
        return this.scheduledStartDate;
    }

    public void setScheduledStartDate(Date scheduledStartDate) {
        this.scheduledStartDate = scheduledStartDate;
    }

    public Date getEndDate() {
        return this.endDate;
    }

    public void setEndDate(Date value) {
        this.endDate = value;
    }

    public Integer getPlannedDuration() {
        return this.plannedDuration;
    }

    public void setPlannedDuration(Integer plannedDuration) {
        this.plannedDuration = plannedDuration;
    }

    public boolean hasPlannedDuration() {
        return this.getPlannedDuration() != null;
    }

    public FlagStatus getFlagStatus() {
        return this.flagStatus;
    }

    public void setFlagStatus(FlagStatus flagStatus) {
        this.flagStatus = flagStatus;
    }

    public String getFlagComment() {
        return this.flagComment;
    }

    public void setFlagComment(String flagComment) {
        this.flagComment = flagComment;
    }

    public boolean isFlagged() {
        return FlagStatus.OK != this.flagStatus;
    }

    public boolean hasStartOrScheduledDate() {
        return this.getStartOrScheduledDate() != null;
    }

    public Date getStartOrScheduledDate() {
        if (this.hasStartDate()) {
            return this.startDate;
        }
        if (this.hasScheduledStartDate()) {
            return this.scheduledStartDate;
        }
        return null;
    }

    public boolean hasEndOrDueDate() {
        return this.getEndOrDueDate() != null;
    }

    public Date getEndOrDueDate() {
        if (this.hasEndDate()) {
            return this.endDate;
        }
        if (this.hasDueDate()) {
            return this.dueDate;
        }
        return null;
    }

    public abstract List<Task> getAllTasks();

    public abstract void accept(ReleaseVisitor var1);

    public abstract boolean hasBeenStarted();

    public abstract boolean isActive();

    public abstract boolean isDone();

    public abstract boolean isDefunct();

    public abstract boolean isUpdatable();

    public abstract boolean isAborted();

    public abstract Release getRelease();

    public abstract String getDisplayPath();

    public abstract List<PlanItem> getChildren();

    public boolean hasScheduledStartDate() {
        return this.scheduledStartDate != null;
    }

    public boolean hasStartDate() {
        return this.startDate != null;
    }

    public boolean hasDueDate() {
        return this.dueDate != null;
    }

    public boolean hasEndDate() {
        return this.endDate != null;
    }

    public Changes moveChildren(int offsetInSeconds) {
        Changes changes = new Changes();
        for (PlanItem item : this.getChildren()) {
            changes.addAll(item.setDates(offsetInSeconds));
        }
        return changes;
    }

    protected Changes setDates(int offsetInSeconds) {
        Changes changes = new Changes();
        if (this.getScheduledStartDate() != null) {
            DateTime newScheduledStartDate = new DateTime((Object)this.getScheduledStartDate()).plusSeconds(offsetInSeconds);
            this.setScheduledStartDate(newScheduledStartDate.toDate());
            changes.update((ConfigurationItem)this);
        }
        if (this.getDueDate() != null) {
            DateTime newDueStartDate = new DateTime((Object)this.getDueDate()).plusSeconds(offsetInSeconds);
            this.setDueDate(newDueStartDate.toDate());
            changes.update((ConfigurationItem)this);
        }
        return changes;
    }

    public String replaceAll(String raw, Map<String, String> replacements, Set<String> unresolvedVariables, boolean freezeEvenIfUnresolved) {
        String result = this.replaceAll(raw, replacements);
        if (!Strings.isNullOrEmpty((String)result)) {
            Set<String> remainingVariables = Variable.collectVariables(result);
            unresolvedVariables.addAll(remainingVariables);
            if (freezeEvenIfUnresolved) {
                for (String remainingVariable : remainingVariables) {
                    result = Variable.freezeUnresolvedVariable(result, remainingVariable);
                }
            }
        }
        return result;
    }

    public String replaceAll(String raw, Map<String, String> replacements) {
        String result = raw;
        if (!Strings.isNullOrEmpty((String)result)) {
            for (Map.Entry<String, String> entry : replacements.entrySet()) {
                result = result.replace(entry.getKey(), entry.getValue());
            }
        }
        return result;
    }

    public void updateDates(Date scheduledStartDate, Date dueDate, Long plannedDuration) {
        Date scheduledOrStartDate;
        Date date = scheduledOrStartDate = this.hasBeenStarted() ? this.startDate : scheduledStartDate;
        if (scheduledOrStartDate != null && dueDate != null && plannedDuration != null) {
            Preconditions.checkArgument((dueDate.getTime() - scheduledOrStartDate.getTime() == plannedDuration ? 1 : 0) != 0, (Object)"start date and due date must be consistent with the duration");
        }
        Preconditions.checkArgument((plannedDuration == null || plannedDuration >= 0L ? 1 : 0) != 0, (Object)"Planned duration cannot be negative");
        if (!this.hasBeenStarted()) {
            this.setScheduledStartDate(scheduledStartDate);
        }
        this.setDueDate(dueDate);
        this.setPlannedDuration(plannedDuration != null ? Integer.valueOf(Ints.checkedCast((long)(plannedDuration / 1000L))) : null);
    }
}

