/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.domain;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem;
import com.xebialabs.deployit.plugin.api.udm.Property;
import com.xebialabs.xlrelease.domain.Changes;
import com.xebialabs.xlrelease.domain.GateTask;
import com.xebialabs.xlrelease.domain.PhaseStatus;
import com.xebialabs.xlrelease.domain.PlanItem;
import com.xebialabs.xlrelease.domain.Release;
import com.xebialabs.xlrelease.domain.ReleaseActivity;
import com.xebialabs.xlrelease.domain.ReleaseVisitor;
import com.xebialabs.xlrelease.domain.Task;
import com.xebialabs.xlrelease.domain.TaskStatus;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;

public class Phase
extends PlanItem {
    @Property(asContainment=true, required=false)
    private List<Task> tasks = Lists.newArrayList();
    @Property
    private PhaseStatus status;
    @Property
    private String color;
    @Property(asContainment=true)
    private Release release;

    public List<Task> getTasks() {
        return this.tasks;
    }

    public void setTasks(List<Task> tasks) {
        this.tasks = tasks;
    }

    public PhaseStatus getStatus() {
        return this.status;
    }

    public void setStatus(PhaseStatus status) {
        this.status = status;
    }

    public String getColor() {
        return this.color;
    }

    public void setColor(String color) {
        this.color = color;
    }

    public Task getCurrentTask() {
        return (Task)((Object)Iterables.find(this.getTasks(), (Predicate)new Predicate<Task>(){

            public boolean apply(Task task) {
                return task.getStatus().isActive();
            }
        }, null));
    }

    public boolean hasCurrentTask() {
        return this.getCurrentTask() != null;
    }

    @Override
    public Release getRelease() {
        return this.release;
    }

    @Override
    public String getDisplayPath() {
        return this.getRelease().getDisplayPath() + " / " + this.getTitle();
    }

    public void setRelease(Release release) {
        this.release = release;
    }

    @VisibleForTesting
    void complete() {
        this.setStatus(PhaseStatus.COMPLETED);
        this.setEndDate(new Date());
        this.freezeVariables();
    }

    private void freezeVariables() {
        if (this.getRelease() == null) {
            return;
        }
        Map<String, String> variables = this.getRelease().getVariableValues();
        if (variables == null || variables.isEmpty()) {
            return;
        }
        this.setTitle(this.replaceAll(this.getTitle(), variables, Sets.newHashSet(), false));
        this.setDescription(this.replaceAll(this.getDescription(), variables, Sets.newHashSet(), false));
    }

    private Task findTopLevelTask(String taskId) {
        for (Task task : this.tasks) {
            if (!taskId.startsWith(task.getId())) continue;
            return task;
        }
        return null;
    }

    @VisibleForTesting
    Task findNextActivableTask() {
        for (Task task : this.tasks) {
            if (task.isDone()) continue;
            return task;
        }
        return null;
    }

    public Changes start() {
        Changes changes = new Changes();
        this.setStatus(PhaseStatus.IN_PROGRESS);
        this.setStartDate(new Date());
        changes.update((ConfigurationItem)this, ReleaseActivity.PHASE_STARTED.create(this.getTitle()));
        if (!this.getTasks().isEmpty()) {
            Task firstTask = this.getTasks().get(0);
            changes.addAll(this.startActivableTask(firstTask));
        } else {
            this.complete();
            changes.update((ConfigurationItem)this, ReleaseActivity.PHASE_COMPLETED.create(this.getTitle()));
        }
        return changes;
    }

    public Changes startPendingTask(String targetTaskId) {
        Changes changes = new Changes();
        Task task = this.findTopLevelTask(targetTaskId);
        if (task != null) {
            changes.addAll(task.startPending(targetTaskId));
            changes.addAll(this.checkTaskStatus(task));
        }
        return changes;
    }

    private Changes startActivableTask(Task firstTask) {
        Changes changes = new Changes();
        changes.addAll(firstTask.start());
        changes.addAll(this.checkTaskStatus(firstTask));
        return changes;
    }

    private Changes checkTaskStatus(Task firstTask) {
        Changes changes = new Changes();
        if (firstTask.isDone()) {
            changes.addAll(this.tryStartingNextTask());
        } else if (firstTask.isFailed()) {
            changes.addAll(this.fail());
        }
        return changes;
    }

    private Changes tryStartingNextTask() {
        Changes changes = new Changes();
        Task nextTask = this.findNextActivableTask();
        if (nextTask == null) {
            this.complete();
            changes.update((ConfigurationItem)this, ReleaseActivity.PHASE_COMPLETED.create(this.getTitle()));
        } else {
            changes.addAll(this.startActivableTask(nextTask));
        }
        return changes;
    }

    public Changes markTaskAsDone(String taskId, TaskStatus status) {
        Changes changes = new Changes();
        Task topLevelTask = this.findTopLevelTask(taskId);
        if (topLevelTask == null) {
            return changes;
        }
        changes.addAll(this.recoverPhaseIfNeeded());
        changes.addAll(topLevelTask.markAsDone(taskId, status));
        if (topLevelTask.isDone()) {
            changes.addAll(this.tryStartingNextTask());
        } else if (topLevelTask.isFailed()) {
            changes.addAll(this.fail());
        } else if (topLevelTask.isFailing()) {
            changes.addAll(this.failing());
        }
        return changes;
    }

    private Changes recoverPhaseIfNeeded() {
        Changes changes = new Changes();
        if (this.getStatus() == PhaseStatus.FAILED || this.getStatus() == PhaseStatus.FAILING) {
            this.setStatus(PhaseStatus.IN_PROGRESS);
            changes.update((ConfigurationItem)this, ReleaseActivity.PHASE_RESTARTED.create(this.getTitle()));
        }
        return changes;
    }

    public Changes failTask(String targetTaskId, String failReason) {
        Changes changes = new Changes();
        Task task = this.findTopLevelTask(targetTaskId);
        if (task == null) {
            return changes;
        }
        changes.addAll(task.fail(targetTaskId, failReason));
        if (task.isFailed()) {
            changes.addAll(this.fail());
        } else if (task.isFailing()) {
            changes.addAll(this.failing());
        }
        return changes;
    }

    public Changes retryTask(String taskId) {
        Changes changes = new Changes();
        Task task = this.findTopLevelTask(taskId);
        if (task == null) {
            return changes;
        }
        boolean taskWasInProgress = task.isInProgress();
        changes.addAll(task.retry(taskId));
        if (taskWasInProgress && task.isInProgress()) {
            return changes;
        }
        changes.update((ConfigurationItem)this, ReleaseActivity.PHASE_RESTARTED.create(this.getTitle()));
        if (!taskWasInProgress && task.isInProgress()) {
            this.setStatus(PhaseStatus.IN_PROGRESS);
        } else {
            changes.addAll(this.checkTaskStatus(task));
        }
        return changes;
    }

    public Changes abort() {
        Changes changes = new Changes();
        this.setStatus(PhaseStatus.ABORTED);
        if (!this.hasStartDate()) {
            this.setStartDate(new Date());
        }
        this.setEndDate(new Date());
        changes.update((ConfigurationItem)this);
        for (Task task : this.tasks) {
            changes.addAll(task.abort());
        }
        return changes;
    }

    public Changes fail() {
        Changes changes = new Changes();
        this.setStatus(PhaseStatus.FAILED);
        changes.update((ConfigurationItem)this, ReleaseActivity.PHASE_FAILED.create(this.getTitle()));
        return changes;
    }

    public Changes failing() {
        Changes changes = new Changes();
        this.setStatus(PhaseStatus.FAILING);
        changes.update((ConfigurationItem)this, ReleaseActivity.PHASE_FAILING.create(this.getTitle()));
        return changes;
    }

    public Task getTask(Integer index) {
        return this.tasks.get(index);
    }

    public List<GateTask> getStartGates() {
        return this.getStartGates(this.tasks);
    }

    public List<GateTask> getEndGates() {
        ArrayList tasks = Lists.newArrayList(this.tasks);
        Collections.reverse(tasks);
        List<GateTask> endGates = this.getStartGates(tasks);
        if (endGates.size() == this.tasks.size()) {
            return Collections.emptyList();
        }
        Collections.reverse(endGates);
        return endGates;
    }

    private List<GateTask> getStartGates(List<Task> tasks) {
        ArrayList gates = Lists.newArrayList();
        for (Task task : tasks) {
            if (!task.isGate()) break;
            gates.add((GateTask)task);
        }
        return gates;
    }

    public boolean areStartGatesOpen() {
        return this.areGatesCompleted(this.getStartGates());
    }

    public boolean areEndGatesOpen() {
        return this.areGatesCompleted(this.getEndGates());
    }

    private boolean areGatesCompleted(Collection<GateTask> gates) {
        for (GateTask gate : gates) {
            if (gate.isDone()) continue;
            return false;
        }
        return true;
    }

    public Changes resetToPlanned() {
        Changes changes = new Changes();
        this.setStatus(PhaseStatus.PLANNED);
        this.setStartDate(null);
        this.setEndDate(null);
        changes.update((ConfigurationItem)this);
        for (Task task : this.tasks) {
            changes.addAll(task.resetToPlanned());
        }
        return changes;
    }

    @Override
    public boolean hasBeenStarted() {
        return this.status != null && this.status.hasBeenStarted();
    }

    @Override
    public boolean isActive() {
        return this.status != null && this.status.isActive();
    }

    @Override
    public boolean isDone() {
        return this.status == PhaseStatus.COMPLETED || this.status == PhaseStatus.SKIPPED;
    }

    @Override
    public boolean isDefunct() {
        return this.isAborted() || this.isDone();
    }

    @Override
    public boolean isUpdatable() {
        return !this.isDefunct();
    }

    @Override
    public boolean isAborted() {
        return this.status == PhaseStatus.ABORTED;
    }

    public boolean isPlanned() {
        return this.status == PhaseStatus.PLANNED;
    }

    public boolean isFailed() {
        return this.status == PhaseStatus.FAILED;
    }

    public boolean isFailing() {
        return this.status == PhaseStatus.FAILING;
    }

    public String getReleaseOwner() {
        return this.release.getOwner();
    }

    @Override
    public List<Task> getAllTasks() {
        ArrayList allTasks = Lists.newArrayList();
        for (Task task : this.tasks) {
            allTasks.addAll(task.getAllTasks());
        }
        return allTasks;
    }

    @Override
    public List<PlanItem> getChildren() {
        ArrayList children = Lists.newArrayList();
        children.addAll(this.getAllTasks());
        return children;
    }

    @Override
    public void accept(ReleaseVisitor visitor) {
        visitor.visit(this);
        for (Task task : this.tasks) {
            task.accept(visitor);
        }
    }
}

