/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.domain;

import com.google.common.base.Strings;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.xebialabs.deployit.plugin.api.reflect.PropertyDescriptor;
import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem;
import com.xebialabs.deployit.plugin.api.udm.Property;
import com.xebialabs.xlrelease.domain.BaseScriptTask;
import com.xebialabs.xlrelease.domain.Changes;
import com.xebialabs.xlrelease.domain.PythonScript;
import com.xebialabs.xlrelease.domain.ReleaseActivity;
import com.xebialabs.xlrelease.domain.ReleaseVisitor;
import com.xebialabs.xlrelease.domain.TaskStatus;
import com.xebialabs.xlrelease.service.ExecutionService;
import com.xebialabs.xlrelease.service.PostStartAction;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class CustomScriptTask
extends BaseScriptTask {
    @Property
    private PythonScript pythonScript;
    @Property
    private Map<String, String> savedVariableProperties = Maps.newHashMap();

    @Override
    public void accept(ReleaseVisitor visitor) {
        super.accept(visitor);
        visitor.visit(this);
    }

    @Override
    protected Set<String> freezeVariablesInCustomFields(Map<String, String> variables, Changes changes, boolean freezeEvenIfUnresolved) {
        PythonScript pythonScript = this.getPythonScript();
        if (this.getStatus() == TaskStatus.IN_PROGRESS) {
            this.saveVariables(pythonScript, pythonScript.getPropertiesWithVariables());
            this.saveVariables(pythonScript, pythonScript.getOutputProperties());
        }
        Collection<PropertyDescriptor> propertiesWithVariables = pythonScript.getPropertiesWithVariables();
        HashSet unresolvedVariables = Sets.newHashSet();
        for (PropertyDescriptor propertyDescriptor : propertiesWithVariables) {
            String value = (String)pythonScript.getProperty(propertyDescriptor.getName());
            value = this.replaceAll(value, variables, unresolvedVariables, freezeEvenIfUnresolved);
            pythonScript.setProperty(propertyDescriptor.getName(), value);
        }
        if (!propertiesWithVariables.isEmpty()) {
            changes.update((ConfigurationItem)pythonScript);
        }
        return unresolvedVariables;
    }

    private void saveVariables(PythonScript pythonScript, Collection<PropertyDescriptor> descriptors) {
        for (PropertyDescriptor propertyDescriptor : descriptors) {
            String propertyName = propertyDescriptor.getName();
            String propertyValue = (String)pythonScript.getProperty(propertyName);
            this.savedVariableProperties.put(propertyName, Strings.nullToEmpty((String)propertyValue));
        }
    }

    @Override
    protected Changes execute(String targetId, ReleaseActivity activity) {
        return this.executeScript(targetId, activity, new PostStartAction(){

            @Override
            public void run(ExecutionService executionService) {
                executionService.executeCustomScript(CustomScriptTask.this);
            }
        });
    }

    public PythonScript getPythonScript() {
        return this.pythonScript;
    }

    public void setPythonScript(PythonScript pythonScript) {
        this.pythonScript = pythonScript;
    }

    public Map<String, String> getSavedVariableProperties() {
        return this.savedVariableProperties;
    }

    public void setSavedVariableProperties(Map<String, String> savedVariableProperties) {
        this.savedVariableProperties = savedVariableProperties;
    }
}

