/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.customscripts;

import com.google.common.base.Predicate;
import com.google.common.collect.FluentIterable;
import com.xebialabs.deployit.plugin.api.reflect.DescriptorRegistry;
import com.xebialabs.deployit.plugin.api.reflect.Type;
import com.xebialabs.xlrelease.domain.PythonScript;
import java.util.Collection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class PythonScriptDefinitions {
    private Collection<Type> types;
    private static final Predicate<Type> IS_NOT_VIRTUAL = new Predicate<Type>(){

        public boolean apply(Type type) {
            return !type.getDescriptor().isVirtual();
        }
    };
    private static final Logger logger = LoggerFactory.getLogger(PythonScriptDefinitions.class);

    public PythonScriptDefinitions() {
        Type pluginScriptType = Type.valueOf(PythonScript.class);
        Collection allTypes = DescriptorRegistry.getSubtypes((Type)pluginScriptType);
        this.types = FluentIterable.from((Iterable)allTypes).filter(IS_NOT_VIRTUAL).toList();
        for (Type type : this.types) {
            logger.info("Custom Python script type loaded : {}", (Object)type);
        }
    }

    public Collection<Type> getTypes() {
        return this.types;
    }
}

