/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.content;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.io.ByteStreams;
import com.xebialabs.deployit.core.rest.resteasy.WorkdirHolder;
import com.xebialabs.deployit.repository.RepositoryService;
import com.xebialabs.xlrelease.domain.Release;
import com.xebialabs.xlrelease.domain.Variable;
import com.xebialabs.xlrelease.export.TemplateImporter;
import com.xebialabs.xlrelease.repository.UserProfiles;
import com.xebialabs.xlrelease.service.ExecutionService;
import com.xebialabs.xlrelease.service.ReleaseEditor;
import com.xebialabs.xlrelease.views.ImportResult;
import com.xebialabs.xlrelease.views.ReleaseForm;
import com.xebialabs.xlrelease.views.UserView;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import org.joda.time.DateTime;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.io.ClassPathResource;

public class Templates {
    private static final Logger logger = LoggerFactory.getLogger(Templates.class);
    private final TemplateImporter templateImporter;
    private final RepositoryService repository;
    private final ReleaseEditor releaseEditor;
    private final ExecutionService executionService;
    private final UserProfiles userProfiles;
    private Map<String, String> templates = Maps.newLinkedHashMap();

    @Autowired
    public Templates(TemplateImporter templateImporter, RepositoryService repository, ReleaseEditor releaseEditor, ExecutionService executionService, UserProfiles userProfiles) {
        this.templateImporter = templateImporter;
        this.repository = repository;
        this.releaseEditor = releaseEditor;
        this.executionService = executionService;
        this.userProfiles = userProfiles;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void importTemplates() {
        WorkdirHolder.initWorkdir();
        try {
            for (Map.Entry<String, String> template : this.templates.entrySet()) {
                this.importTemplate(template.getKey(), template.getValue());
            }
        }
        finally {
            WorkdirHolder.get().delete();
            WorkdirHolder.clear();
        }
    }

    private void importTemplate(String classpathResource, String destinationId) {
        if (this.repository.exists(destinationId)) {
            logger.debug("Template {} already exists.", (Object)destinationId);
            return;
        }
        byte[] template = Templates.getTemplate(classpathResource);
        if (template == null) {
            return;
        }
        ImportResult result = this.templateImporter.importDefaultTemplate(new ByteArrayInputStream(template)).get(0);
        this.repository.move(result.getId(), destinationId);
        logger.info("Imported template {} from {}", (Object)destinationId, (Object)classpathResource);
        for (String warning : result.getWarnings()) {
            logger.info("  Warning: {}", (Object)warning);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static byte[] getTemplate(String classpathResource) {
        try (InputStream in = new ClassPathResource(classpathResource).getInputStream();){
            if (in == null) {
                logger.warn("Could not find template {}", (Object)classpathResource);
                byte[] byArray2 = null;
                return byArray2;
            }
            byte[] byArray = ByteStreams.toByteArray((InputStream)in);
            return byArray;
        }
        catch (IOException e) {
            logger.warn("Could not load template {}: {}", (Object)classpathResource, (Object)e.toString());
            return null;
        }
    }

    public void startWelcomeRelease(String username) {
        String fullNameOrUsername = this.userProfiles.getFullNameOrUsername(username);
        this.startRelease(username, "Applications/ReleaseTemplate_welcome", "Welcome " + fullNameOrUsername);
        if (username.equals("admin")) {
            this.startRelease(username, "Applications/ReleaseTemplate_configure", "Configure XL Release");
        }
    }

    private void startRelease(String username, String templateId, String title) {
        ReleaseForm releaseData = new ReleaseForm();
        releaseData.setOwner(new UserView(username, this.userProfiles));
        releaseData.setScheduledStartDate(new DateTime().withHourOfDay(17).withMinuteOfHour(0).toDate());
        releaseData.setDueDate(new DateTime().plusDays(7).withHourOfDay(17).withMinuteOfHour(0).toDate());
        releaseData.setTitle(title);
        releaseData.setVariables(Lists.newArrayList((Object[])new Variable[]{new Variable("${user}", username)}));
        Release sourceTemplate = (Release)this.repository.read(templateId);
        releaseData.setTags(sourceTemplate.getTags());
        Release welcomeRelease = this.releaseEditor.createFromTemplate(templateId, releaseData.toRelease());
        this.executionService.start(welcomeRelease);
    }

    public Map<String, String> getTemplates() {
        return this.templates;
    }

    public void setTemplates(Map<String, String> templates) {
        this.templates = templates;
    }
}

