/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.builder;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.xebialabs.xlrelease.builder.TaskBuilder;
import com.xebialabs.xlrelease.domain.Link;
import com.xebialabs.xlrelease.domain.ParallelGroup;
import com.xebialabs.xlrelease.domain.Task;
import java.util.List;
import java.util.Set;

public class ParallelGroupBuilder
extends TaskBuilder<ParallelGroup, ParallelGroupBuilder> {
    private List<Task> tasks = Lists.newArrayList();
    private Set<Link> links = Sets.newHashSet();

    public ParallelGroupBuilder withTasks(Task ... tasks) {
        this.tasks = Lists.newArrayList((Object[])tasks);
        return this;
    }

    public ParallelGroupBuilder withLinks(Link ... links) {
        this.links = Sets.newHashSet((Object[])links);
        return this;
    }

    @Override
    protected void setFields(ParallelGroup group) {
        super.setFields(group);
        group.setTasks(this.tasks);
        group.setLinks(this.links);
        for (Task subTask : this.tasks) {
            subTask.setContainer(group);
        }
    }

    @Override
    public ParallelGroup build() {
        ParallelGroup group = (ParallelGroup)new ParallelGroup().getType().getDescriptor().newInstance("dummy");
        this.setFields(group);
        return group;
    }
}

