/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.builder;

import com.google.common.collect.Maps;
import com.xebialabs.deployit.plugin.api.reflect.Type;
import com.xebialabs.xlrelease.builder.BaseScriptTaskBuilder;
import com.xebialabs.xlrelease.domain.CustomScriptTask;
import com.xebialabs.xlrelease.domain.DefaultTaskTypes;
import com.xebialabs.xlrelease.domain.PythonScript;
import java.util.Map;

public class CustomScriptTaskBuilder
extends BaseScriptTaskBuilder<CustomScriptTask, CustomScriptTaskBuilder> {
    private String type;
    private String scriptDefinitionType;
    private Map<String, Object> inputParameters = Maps.newHashMap();
    private Map<String, String> outputProperties = Maps.newHashMap();
    private Map<String, String> savedVariableProperties = Maps.newHashMap();

    public CustomScriptTaskBuilder(String scriptDefinitionType) {
        this.scriptDefinitionType = scriptDefinitionType;
    }

    public CustomScriptTaskBuilder(String scriptDefinitionType, String type) {
        this.scriptDefinitionType = scriptDefinitionType;
        this.type = type;
    }

    public CustomScriptTaskBuilder withInputParameters(Map<String, Object> inputParameters) {
        this.inputParameters = inputParameters;
        return this;
    }

    public CustomScriptTaskBuilder withOutputProperties(Map<String, String> outputProperties) {
        this.outputProperties = outputProperties;
        return this;
    }

    public CustomScriptTaskBuilder withSavedVariableProperties(Map<String, String> savedVariableProperties) {
        this.savedVariableProperties = savedVariableProperties;
        return this;
    }

    @Override
    public CustomScriptTask build() {
        CustomScriptTask task = (CustomScriptTask)DefaultTaskTypes.CUSTOM_SCRIPT_TASK.getType().getDescriptor().newInstance(null);
        PythonScript pythonScript = this.type == null ? (PythonScript)Type.valueOf((String)this.scriptDefinitionType).getDescriptor().newInstance("PythonScript") : (PythonScript)Type.valueOf((String)this.type).getDescriptor().newInstance("PythonScript");
        task.setPythonScript(pythonScript);
        for (Map.Entry<String, Object> entry : this.inputParameters.entrySet()) {
            pythonScript.setProperty(entry.getKey(), entry.getValue());
        }
        for (Map.Entry<String, Object> entry : this.outputProperties.entrySet()) {
            pythonScript.setProperty(entry.getKey(), entry.getValue());
        }
        task.setSavedVariableProperties(this.savedVariableProperties);
        this.setFields(task);
        return task;
    }
}

