/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.builder;

import com.xebialabs.xlrelease.domain.Comment;
import java.util.Date;

public class CommentBuilder {
    private String id;
    private String text;
    private String author;
    private Date date;

    private CommentBuilder() {
    }

    public static CommentBuilder newComment() {
        return new CommentBuilder();
    }

    public CommentBuilder withId(String id) {
        this.id = id;
        return this;
    }

    public CommentBuilder withText(String text) {
        this.text = text;
        return this;
    }

    public CommentBuilder withAuthor(String author) {
        this.author = author;
        return this;
    }

    public CommentBuilder withDate(Date date) {
        this.date = date;
        return this;
    }

    public Comment build() {
        Comment comment = (Comment)new Comment().getType().getDescriptor().newInstance(this.id);
        comment.setText(this.text);
        comment.setAuthor(this.author);
        comment.setDate(this.date);
        return comment;
    }
}

