/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.api;

import com.xebialabs.xlrelease.Environment;
import java.io.File;
import java.io.IOException;
import java.util.Locale;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import org.jboss.resteasy.annotations.cache.NoCache;
import org.springframework.core.io.ClassPathResource;
import org.springframework.core.io.FileSystemResource;
import org.springframework.core.io.Resource;
import org.springframework.security.util.InMemoryResource;
import org.springframework.stereotype.Controller;

@Path(value="/")
@Controller
public class XLReleaseStaticResource {
    private static final InMemoryResource RESOURCE_NOT_FOUND = new InMemoryResource("404"){

        public boolean exists() {
            return false;
        }
    };

    @GET
    @NoCache
    @Produces(value={"text/html;charset=UTF-8"})
    public Response redirectToRoot() throws IOException {
        return this.getRoot("index.html");
    }

    @GET
    @Path(value="{path : static/.*\\.html}")
    @NoCache
    @Produces(value={"text/html;charset=UTF-8"})
    public Response getRoot(@PathParam(value="path") String path) throws IOException {
        return this.stream(path);
    }

    @GET
    @Path(value="{path : static/.*\\.otf}")
    @Produces(value={"font/opentype"})
    public Response getOtfFont(@PathParam(value="path") String path) throws IOException {
        return this.stream(path);
    }

    @GET
    @Path(value="{path : static/.*\\.ico}")
    @Produces(value={"image/vnd.microsoft.icon"})
    public Response getIco(@PathParam(value="path") String path) throws IOException {
        return this.stream(path);
    }

    @GET
    @Path(value="{path : static/.*\\.eot}")
    @Produces(value={"application/vnd.ms-fontobject"})
    public Response getEotFont(@PathParam(value="path") String path) throws IOException {
        return this.stream(path);
    }

    @GET
    @Path(value="{path : .*\\.woff}")
    @Produces(value={"application/font-woff"})
    public Response getWoffFont(@PathParam(value="path") String path) throws IOException {
        return this.stream(path);
    }

    @GET
    @Path(value="{path : static/.*\\.ttf}")
    @Produces(value={"application/x-font-ttf"})
    public Response getTtfFont(@PathParam(value="path") String path) throws IOException {
        return this.stream(path);
    }

    @GET
    @Path(value="{path : static/.*\\.svg}")
    @Produces(value={"image/svg+xml"})
    public Response getSvg(@PathParam(value="path") String path) throws IOException {
        return this.stream(path);
    }

    @GET
    @Path(value="{path : static/.*\\.png}")
    @Produces(value={"image/png"})
    public Response getPng(@PathParam(value="path") String path) throws IOException {
        return this.stream(path);
    }

    @GET
    @Path(value="{path : static/.*\\.gif}")
    @Produces(value={"image/png"})
    public Response getGif(@PathParam(value="path") String path) throws IOException {
        return this.stream(path);
    }

    @GET
    @Path(value="{path : static/.*\\.js}")
    @Produces(value={"application/javascript"})
    public Response getJs(@PathParam(value="path") String path, @Context HttpServletRequest request) throws IOException {
        if (path.endsWith("locale.js")) {
            return this.getLocaleJs(request);
        }
        return this.stream(path);
    }

    public Response getLocaleJs(@Context HttpServletRequest request) throws IOException {
        Resource resource = this.getAngularLocaleResource(request.getLocale());
        if (!resource.exists()) {
            resource = this.getAngularLocaleResource(Locale.ENGLISH);
        }
        return Response.ok((Object)resource.getInputStream()).build();
    }

    private Resource getAngularLocaleResource(Locale locale) throws IOException {
        String localeName = locale.toString();
        String localeNameForAngular = localeName.toLowerCase().replace("_", "-");
        String path = "components/angular-i18n/js/angular-locale_" + localeNameForAngular + ".js";
        return this.resource(path);
    }

    @GET
    @Path(value="{path : static/.*\\.css}")
    @Produces(value={"text/css"})
    public Response getCss(@PathParam(value="path") String path) throws IOException {
        return this.stream(path);
    }

    private Response stream(String path) throws IOException {
        Resource resource = this.resource(path);
        if (!resource.exists()) {
            return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
        }
        return Response.ok((Object)resource.getInputStream()).build();
    }

    private Resource resource(String path) throws IOException {
        path = this.removeStaticAndVersionPrefix(path);
        if (Environment.isDevelopment()) {
            return this.fileSystemResource(path);
        }
        return new ClassPathResource(path);
    }

    private String removeStaticAndVersionPrefix(String path) {
        return path.replaceAll("^static/[^/]+/", "");
    }

    private Resource fileSystemResource(String path) {
        File file = new File(Environment.getWebPath(), path);
        if (file.exists()) {
            return new FileSystemResource(file);
        }
        file = new File(Environment.getBuiltinPluginsPath(), path);
        if (file.exists()) {
            return new FileSystemResource(file);
        }
        return RESOURCE_NOT_FOUND;
    }
}

