/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.api;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.xebialabs.deployit.core.rest.resteasy.WorkdirHolder;
import com.xebialabs.deployit.exception.NotFoundException;
import com.xebialabs.deployit.plumbing.id.IdParam;
import com.xebialabs.xlrelease.api.Transfer;
import com.xebialabs.xlrelease.concurrent.ReleaseIdHolder;
import com.xebialabs.xlrelease.concurrent.Synchronized;
import com.xebialabs.xlrelease.domain.Attachment;
import com.xebialabs.xlrelease.export.TemplateImporter;
import com.xebialabs.xlrelease.repository.Releases;
import com.xebialabs.xlrelease.security.PermissionChecker;
import com.xebialabs.xlrelease.security.XLReleasePermissions;
import com.xebialabs.xlrelease.views.AttachmentView;
import com.xebialabs.xlrelease.views.ImportResult;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import org.apache.commons.fileupload.FileItemIterator;
import org.apache.commons.fileupload.FileItemStream;
import org.apache.commons.fileupload.FileUploadException;
import org.apache.commons.fileupload.servlet.ServletFileUpload;
import org.jboss.resteasy.spi.BadRequestException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.stereotype.Controller;

@Path(value="/upload")
@Consumes(value={"multipart/form-data"})
@Produces(value={"text/html; charset=utf-8"})
@Controller
public class UploadResource {
    private static final String JSON_SUFFIX = ".json";
    private PermissionChecker permissionChecker;
    private TemplateImporter templateImporter;
    private Releases releases;
    private Cache<String, UploadContext> uploadContextCache = CacheBuilder.newBuilder().expireAfterWrite(1L, TimeUnit.MINUTES).build();
    private static final Logger logger = LoggerFactory.getLogger(UploadResource.class);

    @Autowired
    public UploadResource(PermissionChecker permissionChecker, TemplateImporter templateImporter, Releases releases) {
        this.permissionChecker = permissionChecker;
        this.templateImporter = templateImporter;
        this.releases = releases;
    }

    public UploadResource() {
    }

    @GET
    @Path(value="/token/templates")
    public Response getImportTemplatesToken() {
        this.permissionChecker.check(XLReleasePermissions.CREATE_TEMPLATE);
        return Response.ok((Object)this.getToken(UploadType.TEMPLATES)).build();
    }

    @POST
    @Path(value="/templates/zip/{uploadKey}")
    public List<ImportResult> importTemplates(@PathParam(value="uploadKey") String uploadKey, @Context HttpServletRequest request) throws IOException, FileUploadException {
        ServletFileUpload upload = new ServletFileUpload();
        FileItemIterator fileItems = upload.getItemIterator(request);
        while (fileItems.hasNext()) {
            FileItemStream item = fileItems.next();
            if (item.isFormField()) continue;
            return this.importTemplates(uploadKey, item.openStream(), item.getName());
        }
        throw new IllegalArgumentException("Missing file");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting
    List<ImportResult> importTemplates(String uploadKey, InputStream inputStream, String filename) {
        UploadContext uploadContext = this.getUploadContext(uploadKey);
        if (uploadContext.type != UploadType.TEMPLATES) {
            throw new NotFoundException("Upload type mismatch.", new Object[0]);
        }
        this.restoreAuthentication(uploadContext);
        this.permissionChecker.check(XLReleasePermissions.CREATE_TEMPLATE);
        WorkdirHolder.initWorkdir();
        try {
            if (filename.toLowerCase().endsWith(JSON_SUFFIX)) {
                List<ImportResult> list = this.templateImporter.importJSonTemplate(inputStream);
                return list;
            }
            List<ImportResult> list = this.templateImporter.importZippedTemplate(inputStream);
            return list;
        }
        finally {
            WorkdirHolder.get().delete();
            WorkdirHolder.clear();
        }
    }

    @GET
    @Path(value="/token/attachment")
    public Response getUploadAttachmentToken() {
        return Response.ok((Object)this.getToken(UploadType.ATTACHMENT)).build();
    }

    @POST
    @Path(value="/attachment/{ciId}/{uploadKey}")
    @Synchronized
    public List<AttachmentView> addAttachment(@PathParam(value="ciId") @IdParam @ReleaseIdHolder String ciId, @PathParam(value="uploadKey") String uploadKey, @Context HttpServletRequest request) throws IOException, FileUploadException {
        UploadContext uploadContext = this.getUploadContext(uploadKey);
        if (uploadContext.type != UploadType.ATTACHMENT) {
            throw new NotFoundException("Upload type mismatch.", new Object[0]);
        }
        this.restoreAuthentication(uploadContext);
        this.permissionChecker.checkEditPlanItem(ciId);
        if (!ServletFileUpload.isMultipartContent((HttpServletRequest)request)) {
            throw new BadRequestException("Expected multipart content");
        }
        ServletFileUpload upload = new ServletFileUpload();
        FileItemIterator fileItems = upload.getItemIterator(request);
        ArrayList<AttachmentView> returnedViews = new ArrayList<AttachmentView>();
        while (fileItems.hasNext()) {
            FileItemStream item = fileItems.next();
            if (item.isFormField()) continue;
            String filename = item.getName();
            String contentType = item.getContentType();
            InputStream bytes = item.openStream();
            logger.debug("Attaching {} to {}", (Object)filename, (Object)ciId);
            Attachment attachment = this.releases.attach(ciId, filename, contentType, bytes);
            returnedViews.add(AttachmentView.of(attachment));
        }
        if (returnedViews.isEmpty()) {
            throw new BadRequestException("Expected file upload");
        }
        return returnedViews;
    }

    private String getToken(UploadType type) {
        UploadContext uploadContext = new UploadContext(type);
        this.uploadContextCache.put((Object)uploadContext.getKey(), (Object)uploadContext);
        return uploadContext.getKey();
    }

    private UploadContext getUploadContext(String uploadKey) {
        UploadContext uploadContext = (UploadContext)this.uploadContextCache.getIfPresent((Object)uploadKey);
        if (uploadContext == null) {
            throw new NotFoundException("The import with key [%s] was not found.", new Object[]{uploadKey});
        }
        this.uploadContextCache.invalidate((Object)uploadKey);
        return uploadContext;
    }

    private void restoreAuthentication(UploadContext uploadContext) {
        SecurityContextHolder.getContext().setAuthentication(uploadContext.authentication);
    }

    private static class UploadContext
    extends Transfer {
        private final Authentication authentication = SecurityContextHolder.getContext().getAuthentication();
        private final UploadType type;

        UploadContext(UploadType type) {
            this.type = type;
        }
    }

    static enum UploadType {
        TEMPLATES,
        ATTACHMENT;

    }
}

