/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.api;

import com.google.common.collect.Lists;
import com.xebialabs.deployit.plumbing.id.IdParam;
import com.xebialabs.xlrelease.concurrent.ReleaseIdHolder;
import com.xebialabs.xlrelease.concurrent.Synchronized;
import com.xebialabs.xlrelease.domain.Release;
import com.xebialabs.xlrelease.domain.Team;
import com.xebialabs.xlrelease.repository.Ids;
import com.xebialabs.xlrelease.repository.Releases;
import com.xebialabs.xlrelease.repository.UserProfiles;
import com.xebialabs.xlrelease.security.PermissionChecker;
import com.xebialabs.xlrelease.service.ReleaseEditor;
import com.xebialabs.xlrelease.views.TeamView;
import java.util.List;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;

@Path(value="/teams")
@Consumes(value={"application/json"})
@Produces(value={"application/json"})
@Controller
public class TeamResource {
    private Releases releases;
    private ReleaseEditor releaseEditor;
    private PermissionChecker permissions;
    private UserProfiles userProfiles;

    @Autowired
    public TeamResource(Releases releases, ReleaseEditor releaseEditor, PermissionChecker permissions, UserProfiles userProfiles) {
        this.releases = releases;
        this.releaseEditor = releaseEditor;
        this.permissions = permissions;
        this.userProfiles = userProfiles;
    }

    public TeamResource() {
    }

    @GET
    @Path(value="/release/{releaseId}")
    public List<TeamView> getTeamsOfRelease(@PathParam(value="releaseId") @IdParam String releaseId) {
        this.permissions.checkView(releaseId);
        Release release = this.releases.findById(releaseId);
        return Lists.transform(release.getTeams(), TeamView.toTeamView(this.userProfiles));
    }

    @POST
    @Path(value="/release/{releaseId}")
    @Synchronized
    public TeamView addTeam(@PathParam(value="releaseId") @IdParam @ReleaseIdHolder String releaseId, TeamView teamView) {
        this.permissions.checkEdit(releaseId);
        Release release = this.releases.findById(releaseId);
        Team team = this.releaseEditor.addTeam(release, teamView.toTeam());
        return new TeamView(team, this.userProfiles);
    }

    @DELETE
    @Path(value="{teamId}")
    @Synchronized
    public void deleteTeam(@PathParam(value="teamId") @IdParam @ReleaseIdHolder String teamId) {
        this.permissions.checkEdit(Ids.releaseIdFrom(teamId));
        Release release = this.releases.containingTeam(teamId);
        this.releaseEditor.deleteTeam(release, teamId);
    }

    @PUT
    @Path(value="{teamId}")
    @Synchronized
    public TeamView updateTeam(@PathParam(value="teamId") @IdParam @ReleaseIdHolder String teamId, TeamView newTeam) {
        this.permissions.checkEdit(Ids.releaseIdFrom(teamId));
        Team team = this.releaseEditor.updateTeam(teamId, newTeam.toTeam());
        return new TeamView(team, this.userProfiles);
    }
}

