/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.api;

import com.google.common.base.Function;
import com.google.common.collect.Lists;
import com.xebialabs.deployit.core.api.dto.RolePrincipals;
import com.xebialabs.deployit.core.rest.api.DtoWriter;
import com.xebialabs.deployit.core.rest.api.SecurityResource;
import com.xebialabs.deployit.security.RoleService;
import com.xebialabs.deployit.security.permission.PlatformPermissions;
import com.xebialabs.xlrelease.repository.UserProfiles;
import com.xebialabs.xlrelease.security.PermissionChecker;
import com.xebialabs.xlrelease.views.RolePrincipalsView;
import java.util.List;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;

@Path(value="/roles")
@Consumes(value={"application/json"})
@Produces(value={"application/json"})
@Controller
public class RolePrincipalsResource {
    private SecurityResource securityResource;
    private PermissionChecker permissionChecker;
    private RoleService roleService;
    private DtoWriter dtoWriter = new DtoWriter();
    private UserProfiles userProfiles;
    private static final Function<RolePrincipals, String> TO_ROLE_NAME = new Function<RolePrincipals, String>(){

        public String apply(RolePrincipals rolePrincipals) {
            return rolePrincipals.getRole().getName();
        }
    };

    @Autowired
    public RolePrincipalsResource(SecurityResource securityResource, PermissionChecker permissionChecker, RoleService roleService, UserProfiles userProfiles) {
        this.securityResource = securityResource;
        this.permissionChecker = permissionChecker;
        this.roleService = roleService;
        this.userProfiles = userProfiles;
    }

    @GET
    @Path(value="names")
    public List<String> readRoleNames() {
        List<RolePrincipals> assignments = this.getRolePrincipalsList();
        return Lists.transform(assignments, TO_ROLE_NAME);
    }

    @GET
    @Path(value="principals")
    public List<RolePrincipalsView> readRolePrincipals() {
        this.permissionChecker.check(PlatformPermissions.EDIT_SECURITY);
        List<RolePrincipals> assignments = this.getRolePrincipalsList();
        return Lists.transform(assignments, RolePrincipalsView.toRolePrincipalsView(this.userProfiles));
    }

    @PUT
    @Path(value="principals")
    public void setGlobalRolePermissions(List<RolePrincipalsView> rolePrincipalsViews) {
        this.permissionChecker.check(PlatformPermissions.EDIT_SECURITY);
        List rolePrincipals = Lists.transform(rolePrincipalsViews, RolePrincipalsView.TO_ROLE_PRINCIPAL);
        this.securityResource.writeRolePrincipals(rolePrincipals);
    }

    private List<RolePrincipals> getRolePrincipalsList() {
        List multimap = this.roleService.readRoleAssignments();
        return this.dtoWriter.writeRoleAssignments(multimap);
    }
}

