/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.api;

import com.xebialabs.deployit.exception.NotFoundException;
import com.xebialabs.deployit.plumbing.DateParam;
import com.xebialabs.deployit.repository.RepositoryService;
import com.xebialabs.xlrelease.api.ExportResource;
import com.xebialabs.xlrelease.configuration.ReportsSettings;
import com.xebialabs.xlrelease.reports.PhaseDuration;
import com.xebialabs.xlrelease.reports.ReleaseAutomationData;
import com.xebialabs.xlrelease.reports.ReleasesAutomation;
import com.xebialabs.xlrelease.reports.ReleasesDuration;
import com.xebialabs.xlrelease.reports.TaskDuration;
import com.xebialabs.xlrelease.reports.UserParticipation;
import com.xebialabs.xlrelease.security.PermissionChecker;
import com.xebialabs.xlrelease.security.XLReleasePermissions;
import com.xebialabs.xlrelease.service.ReportServiceCache;
import com.xebialabs.xlrelease.views.Point;
import com.xebialabs.xlrelease.views.ReportsSettingsView;
import com.xebialabs.xlrelease.views.TimeFrame;
import java.util.Date;
import java.util.List;
import javax.ws.rs.Consumes;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;

@Path(value="/reports")
@Consumes(value={"application/json"})
@Produces(value={"application/json"})
@Controller
public class ReportResource {
    private ReportServiceCache reportService;
    private PermissionChecker permissions;
    private ExportResource exportResource;
    private RepositoryService repositoryService;

    @Autowired
    public ReportResource(ReportServiceCache reportService, PermissionChecker permissions, ExportResource exportResource, RepositoryService repositoryService) {
        this.reportService = reportService;
        this.permissions = permissions;
        this.exportResource = exportResource;
        this.repositoryService = repositoryService;
    }

    @GET
    @Path(value="/releases/duration")
    public ReleasesDuration getReleaseDuration(@DefaultValue(value="LAST_SIX_MONTHS") @QueryParam(value="timeFrame") TimeFrame timeFrame, @QueryParam(value="tags") List<String> tags, @DateParam @QueryParam(value="from") Date from, @DateParam @QueryParam(value="to") Date to) {
        this.permissions.check(XLReleasePermissions.VIEW_REPORTS);
        return this.reportService.getReleaseDuration(timeFrame, tags, from, to);
    }

    @GET
    @Path(value="/most-involved-people")
    public List<UserParticipation> getTopPeopleMostInvolved(@DefaultValue(value="LAST_SIX_MONTHS") @QueryParam(value="timeFrame") TimeFrame timeFrame, @QueryParam(value="tags") List<String> tags, @DateParam @QueryParam(value="from") Date from, @DateParam @QueryParam(value="to") Date to) {
        this.permissions.check(XLReleasePermissions.VIEW_REPORTS);
        return this.reportService.getTopPeopleMostInvolved(timeFrame, tags, from, to);
    }

    @GET
    @Path(value="/longest-tasks")
    public List<TaskDuration> getTopLongestTasks(@DefaultValue(value="LAST_SIX_MONTHS") @QueryParam(value="timeFrame") TimeFrame timeFrame, @QueryParam(value="tags") List<String> tags, @DateParam @QueryParam(value="from") Date from, @DateParam @QueryParam(value="to") Date to) {
        this.permissions.check(XLReleasePermissions.VIEW_REPORTS);
        return this.reportService.getTopLongestTasks(timeFrame, tags, from, to);
    }

    @GET
    @Path(value="/releases/automation")
    public ReleasesAutomation getReleaseAutomation(@DefaultValue(value="LAST_SIX_MONTHS") @QueryParam(value="timeFrame") TimeFrame timeFrame, @QueryParam(value="tags") List<String> tags, @DateParam @QueryParam(value="from") Date from, @DateParam @QueryParam(value="to") Date to) {
        this.permissions.check(XLReleasePermissions.VIEW_REPORTS);
        return this.reportService.getReleaseAutomationSeries(timeFrame, tags, from, to);
    }

    @GET
    @Path(value="/longest-phases")
    public List<PhaseDuration> getTopLongestPhases(@DefaultValue(value="LAST_SIX_MONTHS") @QueryParam(value="timeFrame") TimeFrame timeFrame, @QueryParam(value="tags") List<String> tags, @DateParam @QueryParam(value="from") Date from, @DateParam @QueryParam(value="to") Date to) {
        this.permissions.check(XLReleasePermissions.VIEW_REPORTS);
        return this.reportService.getTopLongestPhases(timeFrame, tags, from, to);
    }

    @GET
    @Path(value="/releases/number-by-month")
    public List<Point> getNumberOfReleaseByMonth(@DefaultValue(value="LAST_SIX_MONTHS") @QueryParam(value="timeFrame") TimeFrame timeFrame, @QueryParam(value="tags") List<String> tags, @DateParam @QueryParam(value="from") Date from, @DateParam @QueryParam(value="to") Date to) {
        this.permissions.check(XLReleasePermissions.VIEW_REPORTS);
        return this.reportService.getNumberOfReleaseByMonth(timeFrame, tags, from, to);
    }

    @GET
    @Path(value="/releases/most-recent/{limit}")
    public List<ReleaseAutomationData> getMostRecentReleaseData(@PathParam(value="limit") Integer limit, @QueryParam(value="tags") List<String> tags) {
        this.permissions.check(XLReleasePermissions.VIEW_REPORTS);
        return this.reportService.getMostRecentReleasesData(tags, limit);
    }

    @GET
    @Path(value="/export")
    public Response exportReport(@DefaultValue(value="LAST_SIX_MONTHS") @QueryParam(value="since") TimeFrame timeFrame, @QueryParam(value="report") ReportType report, @QueryParam(value="tags") List<String> tags, @QueryParam(value="from") @DateParam Date from, @QueryParam(value="to") @DateParam Date to) {
        this.permissions.check(XLReleasePermissions.VIEW_REPORTS);
        String downloadToken = this.exportResource.registerReport(report, timeFrame, tags, from, to);
        return Response.ok((Object)downloadToken).build();
    }

    @GET
    @Path(value="/settings")
    public ReportsSettingsView getReportsSettings() {
        ReportsSettings reportsSettings = null;
        try {
            reportsSettings = (ReportsSettings)this.repositoryService.read("Configuration/reports/ReportsSettings");
        }
        catch (NotFoundException notFoundException) {
            // empty catch block
        }
        if (reportsSettings == null) {
            return ReportsSettingsView.defaultValues();
        }
        return new ReportsSettingsView(reportsSettings);
    }

    public static enum ReportType {
        RELEASE_DURATION,
        RELEASE_AUTOMATION,
        TOP_PEOPLE_MOST_INVOLVED,
        TOP_LONGEST_TASK,
        TOP_LONGEST_PHASE,
        TOP_LONGEST_RELEASE,
        NUMBER_OF_RELEASE_BY_MONTH;

    }
}

