/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.api;

import com.google.common.base.Predicate;
import com.google.common.collect.Collections2;
import com.google.common.collect.Lists;
import com.xebialabs.deployit.plumbing.id.IdParam;
import com.xebialabs.deployit.repository.RepositoryService;
import com.xebialabs.xlrelease.api.ExportResource;
import com.xebialabs.xlrelease.concurrent.ReleaseIdHolder;
import com.xebialabs.xlrelease.concurrent.Synchronized;
import com.xebialabs.xlrelease.domain.Phase;
import com.xebialabs.xlrelease.domain.PlanItem;
import com.xebialabs.xlrelease.domain.Release;
import com.xebialabs.xlrelease.domain.Task;
import com.xebialabs.xlrelease.domain.Variable;
import com.xebialabs.xlrelease.repository.Phases;
import com.xebialabs.xlrelease.repository.Releases;
import com.xebialabs.xlrelease.repository.UserProfiles;
import com.xebialabs.xlrelease.security.PermissionChecker;
import com.xebialabs.xlrelease.security.XLReleasePermissions;
import com.xebialabs.xlrelease.service.ExecutionService;
import com.xebialabs.xlrelease.service.LogsService;
import com.xebialabs.xlrelease.service.ReleaseEditor;
import com.xebialabs.xlrelease.views.ActivityLogEntryView;
import com.xebialabs.xlrelease.views.LogsFilters;
import com.xebialabs.xlrelease.views.MovementIndexes;
import com.xebialabs.xlrelease.views.PhaseFullView;
import com.xebialabs.xlrelease.views.ReleaseForm;
import com.xebialabs.xlrelease.views.ReleaseFullView;
import com.xebialabs.xlrelease.views.ReleasePermissionsView;
import com.xebialabs.xlrelease.views.ReleasesFilters;
import com.xebialabs.xlrelease.views.TaskFullView;
import com.xebialabs.xlrelease.views.TeamView;
import java.util.Collections;
import java.util.List;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import org.jboss.resteasy.spi.BadRequestException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;

@Path(value="/releases")
@Consumes(value={"application/json"})
@Produces(value={"application/json"})
@Controller
public class ReleaseResource {
    private static final Predicate<Task> IS_AUTOMATED_IN_PROGRESS = new Predicate<Task>(){

        public boolean apply(Task task) {
            boolean isAutomated = (Boolean)task.getProperty("automated");
            return isAutomated && task.isInProgress();
        }
    };
    private RepositoryService repositoryService;
    private Releases releases;
    private PermissionChecker permissions;
    private ReleaseEditor releaseEditor;
    private ExecutionService executionService;
    private Phases phases;
    private ExportResource exportResource;
    private UserProfiles userProfiles;
    private LogsService logsService;

    @Autowired
    public ReleaseResource(Releases releases, PermissionChecker permissions, RepositoryService repositoryService, ReleaseEditor releaseEditor, ExecutionService executionService, Phases phases, ExportResource exportResource, UserProfiles userProfiles, LogsService logsService) {
        this.releases = releases;
        this.permissions = permissions;
        this.repositoryService = repositoryService;
        this.releaseEditor = releaseEditor;
        this.executionService = executionService;
        this.phases = phases;
        this.exportResource = exportResource;
        this.userProfiles = userProfiles;
        this.logsService = logsService;
    }

    public ReleaseResource() {
    }

    @GET
    @Path(value="templates")
    public List<ReleaseFullView> getTemplates(@QueryParam(value="filter") String filter) {
        List<Release> templates = this.permissions.filter(this.releases.findAllTemplates(filter), XLReleasePermissions.VIEW_TEMPLATE);
        Collections.sort(templates, PlanItem.BY_TITLE);
        return Lists.transform(templates, ReleaseFullView.toReleaseFullView(this.userProfiles));
    }

    @POST
    @Path(value="templates")
    public ReleaseFullView createTemplate(ReleaseForm templateForm) {
        this.permissions.check(XLReleasePermissions.CREATE_TEMPLATE);
        Release release = templateForm.getTemplateId() == null ? this.releaseEditor.createTemplate(templateForm.toTemplate()) : this.releases.copyTemplate(templateForm.getTemplateId(), templateForm.toTemplate());
        return new ReleaseFullView(release, this.userProfiles);
    }

    @DELETE
    @Path(value="templates/{templateId}")
    public Response deleteTemplate(@PathParam(value="templateId") @IdParam String templateId) {
        this.permissions.check(XLReleasePermissions.CREATE_TEMPLATE);
        this.repositoryService.delete(new String[]{templateId});
        return Response.status((Response.Status)Response.Status.OK).build();
    }

    @PUT
    @Path(value="templates/{templateId}")
    @Synchronized
    public ReleaseFullView updateTemplate(@PathParam(value="templateId") @IdParam @ReleaseIdHolder String templateId, ReleaseForm releaseForm) {
        this.permissions.check(XLReleasePermissions.EDIT_TEMPLATE, templateId);
        Release template = this.releaseEditor.updateTemplate(templateId, releaseForm, releaseForm.getTags());
        return new ReleaseFullView(template, this.userProfiles);
    }

    @POST
    @Path(value="search")
    public List<ReleaseFullView> searchReleases(ReleasesFilters releasesFilters) {
        List<Release> viewableReleases = this.permissions.filter(this.releases.findAll(releasesFilters), XLReleasePermissions.VIEW_RELEASE);
        Collections.sort(viewableReleases, PlanItem.BY_TITLE);
        return Lists.transform(viewableReleases, ReleaseFullView.toReleaseFullView(this.userProfiles));
    }

    @POST
    public ReleaseFullView createRelease(ReleaseForm releaseForm) {
        Release release;
        if (!releaseForm.hasValidDates()) {
            throw new BadRequestException("Scheduled start date must be before due date");
        }
        if (releaseForm.isFromTemplate()) {
            this.permissions.checkIsAllowedToCreateReleaseFromTemplate(releaseForm.getTemplateId());
            release = this.releaseEditor.createFromTemplate(releaseForm.getTemplateId(), releaseForm.toRelease());
        } else {
            this.permissions.check(XLReleasePermissions.CREATE_RELEASE);
            release = this.releaseEditor.createWithoutTemplate(releaseForm.toRelease());
        }
        return new ReleaseFullView(release, this.userProfiles);
    }

    @PUT
    @Path(value="{releaseId}")
    @Synchronized
    public ReleaseFullView updateRelease(@PathParam(value="releaseId") @IdParam @ReleaseIdHolder String releaseId, ReleaseForm releaseForm) {
        this.permissions.check(XLReleasePermissions.EDIT_RELEASE, releaseId);
        Release release = this.releaseEditor.updateRelease(releaseId, releaseForm);
        return new ReleaseFullView(release, this.userProfiles);
    }

    @POST
    @Path(value="{releaseId}/start")
    @Synchronized
    public ReleaseFullView startRelease(@PathParam(value="releaseId") @IdParam @ReleaseIdHolder String releaseId) {
        this.permissions.check(XLReleasePermissions.START_RELEASE, releaseId);
        Release release = this.executionService.start(releaseId);
        return new ReleaseFullView(release, this.userProfiles);
    }

    @POST
    @Path(value="{releaseId}/abort")
    @Synchronized
    public ReleaseFullView abortRelease(@PathParam(value="releaseId") @IdParam @ReleaseIdHolder String releaseId) {
        this.permissions.check(XLReleasePermissions.ABORT_RELEASE, releaseId);
        this.checkNoAutomatedTaskRunning(releaseId, "You can not abort a release when an automated task is running");
        Release release = this.executionService.abort(releaseId);
        return new ReleaseFullView(release, this.userProfiles);
    }

    @GET
    @Path(value="{releaseId}")
    public ReleaseFullView getRelease(@PathParam(value="releaseId") @IdParam String releaseId) {
        this.permissions.checkView(releaseId);
        Release release = this.releases.findById(releaseId);
        return new ReleaseFullView(release, this.userProfiles);
    }

    @GET
    @Path(value="{releaseId}/export")
    public Response exportRelease(@PathParam(value="releaseId") @IdParam String releaseId, @QueryParam(value="format") String format) {
        this.permissions.checkView(releaseId);
        String downloadToken = this.exportResource.registerExport(releaseId, format);
        return Response.ok((Object)downloadToken).build();
    }

    @POST
    @Path(value="{releaseId}/phases/move")
    @Synchronized
    public PhaseFullView movePhase(@PathParam(value="releaseId") @IdParam @ReleaseIdHolder String releaseId, MovementIndexes movementIndexes) {
        this.permissions.checkEdit(releaseId);
        Release release = this.releases.findById(releaseId);
        Phase movedPhase = this.releaseEditor.movePhase(release, movementIndexes);
        return new PhaseFullView(movedPhase, this.userProfiles);
    }

    @POST
    @Path(value="{releaseId}/tasks/move")
    @Synchronized
    public TaskFullView moveTask(@PathParam(value="releaseId") @IdParam @ReleaseIdHolder String releaseId, MovementIndexes movementIndexes) {
        this.permissions.checkEdit(releaseId);
        Task movedTask = this.releaseEditor.moveTask(movementIndexes);
        return new TaskFullView(movedTask, this.userProfiles);
    }

    @POST
    @Path(value="{releaseId}/phases/add")
    @Synchronized
    public PhaseFullView addPhase(@PathParam(value="releaseId") @IdParam @ReleaseIdHolder String releaseId) {
        this.permissions.checkEdit(releaseId);
        Phase phase = this.phases.create(releaseId);
        return new PhaseFullView(phase, this.userProfiles);
    }

    @PUT
    @Path(value="{releaseId}/tasks/duplicate/{taskId}")
    @Synchronized
    public TaskFullView duplicateTask(@PathParam(value="releaseId") @IdParam @ReleaseIdHolder String releaseId, @PathParam(value="taskId") @IdParam String originTaskId) {
        this.permissions.checkEdit(releaseId);
        Task duplicateTask = this.releaseEditor.duplicateTask(originTaskId);
        return new TaskFullView(duplicateTask, this.userProfiles);
    }

    @PUT
    @Path(value="{releaseId}/phases/duplicate/{phaseId}")
    @Synchronized
    public PhaseFullView duplicatePhase(@PathParam(value="releaseId") @IdParam @ReleaseIdHolder String releaseId, @PathParam(value="phaseId") @IdParam String originPhaseId) {
        this.permissions.checkEdit(releaseId);
        Release release = this.releases.findById(releaseId);
        Phase duplicatePhase = this.releaseEditor.duplicatePhase(release, originPhaseId);
        return new PhaseFullView(duplicatePhase, this.userProfiles);
    }

    @POST
    @Path(value="{releaseId}/logs/search")
    public List<ActivityLogEntryView> searchLogs(@PathParam(value="releaseId") @IdParam String releaseId, LogsFilters filters) {
        this.permissions.checkView(releaseId);
        return Lists.transform(this.logsService.getFilteredLogs(releaseId, filters), ActivityLogEntryView.toActivityLogEntryView(this.userProfiles));
    }

    @PUT
    @Path(value="{releaseId}/variables")
    @Synchronized
    public List<Variable> updateVariables(@PathParam(value="releaseId") @IdParam @ReleaseIdHolder String releaseId, List<Variable> variables) {
        this.permissions.check(XLReleasePermissions.EDIT_RELEASE, releaseId);
        Release release = this.releaseEditor.updateVariables(releaseId, variables);
        return Variable.mapToList(release.getVariableValues());
    }

    @GET
    @Path(value="{releaseId}/permissions")
    public ReleasePermissionsView getPermissions(@PathParam(value="releaseId") @IdParam String releaseId) {
        this.permissions.checkEditSecurity(releaseId);
        Release release = this.releases.findById(releaseId);
        List<String> permissions = release.isTemplate() ? XLReleasePermissions.getTemplatePermissions() : XLReleasePermissions.getReleasePermissions();
        return new ReleasePermissionsView(permissions, release, this.userProfiles);
    }

    @PUT
    @Path(value="{releaseId}/permissions")
    @Synchronized
    public ReleasePermissionsView updatePermissions(@PathParam(value="releaseId") @IdParam @ReleaseIdHolder String releaseId, List<TeamView> teamViews) {
        this.permissions.checkEditSecurity(releaseId);
        Release release = this.releaseEditor.updatePermissions(releaseId, Lists.transform(teamViews, TeamView.TO_TEAM));
        List<String> permissions = release.isTemplate() ? XLReleasePermissions.getTemplatePermissions() : XLReleasePermissions.getReleasePermissions();
        return new ReleasePermissionsView(permissions, release, this.userProfiles);
    }

    @POST
    @Path(value="{releaseId}/restartPhasesFrom/{phaseId}")
    @Synchronized
    public ReleaseFullView restartPhasesFrom(@PathParam(value="releaseId") @IdParam @ReleaseIdHolder String releaseId, @PathParam(value="phaseId") @IdParam String phaseId) {
        this.permissions.check(XLReleasePermissions.EDIT_RELEASE, releaseId);
        this.checkNoAutomatedTaskRunning(releaseId, "You can not restart phases when an automated task is running");
        Release release = this.releaseEditor.restartPhasesFrom(releaseId, phaseId);
        return new ReleaseFullView(release, this.userProfiles);
    }

    @POST
    @Path(value="{releaseId}/resume")
    @Synchronized
    public ReleaseFullView resume(@PathParam(value="releaseId") @IdParam @ReleaseIdHolder String releaseId, List<Variable> variables) {
        this.permissions.check(XLReleasePermissions.EDIT_RELEASE, releaseId);
        this.releaseEditor.updateVariables(releaseId, variables);
        Release release = this.executionService.resume(releaseId);
        return new ReleaseFullView(release, this.userProfiles);
    }

    @DELETE
    @Path(value="{releaseId}/attachments/{attachmentId}")
    @Synchronized
    public void deleteAttachment(@PathParam(value="releaseId") @IdParam @ReleaseIdHolder String releaseId, @PathParam(value="attachmentId") @IdParam String attachmentId) {
        this.permissions.check(XLReleasePermissions.EDIT_RELEASE, releaseId);
        this.releases.deleteAttachment(releaseId, attachmentId);
    }

    @DELETE
    @Path(value="{releaseId}/{taskId}/attachments/{attachmentId}")
    @Synchronized
    public void deleteAttachmentFromTask(@PathParam(value="releaseId") @IdParam @ReleaseIdHolder String releaseId, @PathParam(value="taskId") @IdParam String taskId, @PathParam(value="attachmentId") @IdParam String attachmentId) {
        this.permissions.check(XLReleasePermissions.EDIT_RELEASE_TASK, releaseId);
        this.releases.deleteAttachmentFromTask(releaseId, taskId, attachmentId);
    }

    private void checkNoAutomatedTaskRunning(String releaseId, String message) {
        Release release = this.releases.findById(releaseId);
        if (!Collections2.filter(release.getAllTasks(), IS_AUTOMATED_IN_PROGRESS).isEmpty()) {
            throw new IllegalStateException(message);
        }
    }
}

