/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.api;

import com.google.common.base.Preconditions;
import com.xebialabs.deployit.booter.local.utils.Strings;
import com.xebialabs.deployit.engine.spi.exception.DeployitException;
import com.xebialabs.deployit.engine.spi.exception.HttpResponseCodeResult;
import com.xebialabs.deployit.security.JcrUserService;
import com.xebialabs.deployit.security.Permissions;
import com.xebialabs.xlrelease.configuration.UserProfile;
import com.xebialabs.xlrelease.repository.UserProfiles;
import com.xebialabs.xlrelease.service.JcrUsers;
import com.xebialabs.xlrelease.views.UserAccount;
import java.util.Objects;
import javax.jcr.RepositoryException;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;

@Path(value="/profile")
@Consumes(value={"application/json"})
@Produces(value={"application/json"})
@Controller
public class ProfileResource {
    private UserProfiles userProfiles;
    private JcrUserService jcrUserService;
    private JcrUsers jcrUsers;

    @Autowired
    public ProfileResource(UserProfiles userProfiles, JcrUserService jcrUserService, JcrUsers jcrUsers) {
        this.userProfiles = userProfiles;
        this.jcrUserService = jcrUserService;
        this.jcrUsers = jcrUsers;
    }

    @GET
    public UserAccount getProfile() {
        String authenticatedUsername = Permissions.getAuthenticatedUserName();
        UserProfile userProfile = this.userProfiles.findByUsername(authenticatedUsername);
        return new UserAccount(userProfile.getName(), userProfile, this.jcrUsers.userExistsInJcr(authenticatedUsername));
    }

    @PUT
    public UserAccount saveProfile(UserAccount userAccount) {
        String authenticatedUsername = Permissions.getAuthenticatedUserName();
        UserProfile existingProfile = this.userProfiles.findByUsername(authenticatedUsername);
        UserProfile updatedProfile = new UserProfile(existingProfile.getId(), userAccount.getEmail(), userAccount.getFullName());
        this.userProfiles.save(updatedProfile);
        if (userAccount.hasPassword() && this.jcrUsers.userExistsInJcr(authenticatedUsername)) {
            Preconditions.checkArgument((!Objects.equals(authenticatedUsername, "admin") ? 1 : 0) != 0, (Object)"Admin password can't be changed.");
            Preconditions.checkArgument((boolean)Strings.isNotBlank((String)userAccount.getPreviousPassword()), (Object)"Previous password must be provided when changing the password.");
            try {
                this.jcrUserService.modifyPassword(authenticatedUsername, userAccount.getPassword(), userAccount.getPreviousPassword());
            }
            catch (Exception e) {
                if (e.getCause() instanceof RepositoryException) {
                    throw new InvalidPreviousPasswordException(e);
                }
                throw e;
            }
        }
        return new UserAccount(updatedProfile.getName(), updatedProfile, this.jcrUsers.userExistsInJcr(authenticatedUsername));
    }

    @HttpResponseCodeResult(statusCode=400)
    public static class InvalidPreviousPasswordException
    extends DeployitException {
        public InvalidPreviousPasswordException(Throwable cause) {
            super(cause);
        }
    }
}

