/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.api;

import com.google.common.base.Preconditions;
import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem;
import com.xebialabs.deployit.plumbing.id.IdParam;
import com.xebialabs.deployit.repository.RepositoryService;
import com.xebialabs.xlrelease.concurrent.ReleaseIdHolder;
import com.xebialabs.xlrelease.concurrent.Synchronized;
import com.xebialabs.xlrelease.domain.Link;
import com.xebialabs.xlrelease.domain.PlanItem;
import com.xebialabs.xlrelease.repository.Ids;
import com.xebialabs.xlrelease.repository.Links;
import com.xebialabs.xlrelease.security.PermissionChecker;
import com.xebialabs.xlrelease.views.DatesForm;
import com.xebialabs.xlrelease.views.LinkForm;
import com.xebialabs.xlrelease.views.LinkView;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;

@Path(value="/planning")
@Consumes(value={"application/json"})
@Produces(value={"application/json"})
@Controller
public class PlanningResource {
    private PermissionChecker permissionChecker;
    private Links links;
    private RepositoryService repositoryService;

    @Autowired
    public PlanningResource(PermissionChecker permissionChecker, Links links, RepositoryService repositoryService) {
        this.repositoryService = repositoryService;
        this.permissionChecker = permissionChecker;
        this.links = links;
    }

    public PlanningResource() {
    }

    @PUT
    @Synchronized
    @Path(value="{planItemId}")
    public void updateDates(@PathParam(value="planItemId") @IdParam @ReleaseIdHolder String planItemId, DatesForm datesForm) {
        this.permissionChecker.checkEditPlanItem(planItemId);
        PlanItem item = (PlanItem)this.repositoryService.read(planItemId);
        Preconditions.checkArgument((boolean)item.isUpdatable());
        item.updateDates(datesForm.getScheduledStartDate(), datesForm.getDueDate(), datesForm.getPlannedDuration());
        this.repositoryService.update((ConfigurationItem[])new PlanItem[]{item});
    }

    @POST
    @Path(value="/links/{containerId}")
    @Synchronized
    public LinkView addLink(@PathParam(value="containerId") @IdParam @ReleaseIdHolder String containerId, LinkForm linkForm) {
        this.permissionChecker.checkEdit(Ids.releaseIdFrom(containerId));
        Link link = this.links.create(containerId, linkForm.getSourceId(), linkForm.getTargetId());
        return new LinkView(link);
    }

    @DELETE
    @Path(value="/links/{linkId}")
    @Synchronized
    public void removeLink(@PathParam(value="linkId") @IdParam @ReleaseIdHolder String linkId) {
        this.permissionChecker.checkEdit(Ids.releaseIdFrom(linkId));
        this.links.delete(linkId);
    }
}

