/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.api;

import com.google.common.base.Charsets;
import com.google.common.base.Function;
import com.google.common.collect.Lists;
import com.xebialabs.deployit.core.api.InternalSecurityProxy;
import com.xebialabs.deployit.core.api.dto.RolePermissions;
import com.xebialabs.deployit.core.rest.api.UserResource;
import com.xebialabs.deployit.core.rest.resteasy.Workdir;
import com.xebialabs.deployit.core.rest.resteasy.WorkdirHolder;
import com.xebialabs.deployit.engine.api.security.User;
import com.xebialabs.deployit.plugin.api.reflect.Type;
import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem;
import com.xebialabs.deployit.plugin.api.udm.Metadata;
import com.xebialabs.deployit.plumbing.id.IdParam;
import com.xebialabs.deployit.repository.RepositoryService;
import com.xebialabs.deployit.repository.SearchParameters;
import com.xebialabs.deployit.security.permission.PlatformPermissions;
import com.xebialabs.overthere.OverthereFile;
import com.xebialabs.xlrelease.configuration.DeployitServerDefinition;
import com.xebialabs.xlrelease.configuration.UserProfile;
import com.xebialabs.xlrelease.domain.Attachment;
import com.xebialabs.xlrelease.domain.Release;
import com.xebialabs.xlrelease.repository.DeployitServers;
import com.xebialabs.xlrelease.repository.UserProfiles;
import com.xebialabs.xlrelease.security.PermissionChecker;
import com.xebialabs.xlrelease.views.FixturesUser;
import com.xebialabs.xlrelease.views.RolePermissionsView;
import com.xebialabs.xlrelease.views.RolePrincipalsView;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.List;
import java.util.Objects;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import org.jboss.resteasy.annotations.cache.NoCache;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.util.FileCopyUtils;

@Path(value="/fixtures")
@Consumes(value={"application/json"})
@Produces(value={"application/json"})
@Controller
@NoCache
public class FixturesResource {
    private static final String USER_PATH = Metadata.ConfigurationItemRoot.CONFIGURATION.getRootNodeName() + "/Users/";
    private RepositoryService repositoryService;
    private UserResource userResource;
    private DeployitServers deployitServers;
    private PermissionChecker permissions;
    private InternalSecurityProxy internalSecurityProxy;
    private UserProfiles userProfiles;

    @Autowired
    public FixturesResource(RepositoryService repositoryService, UserResource userResource, DeployitServers deployitServers, PermissionChecker permissions, InternalSecurityProxy internalSecurityProxy, UserProfiles userProfiles) {
        this.repositoryService = repositoryService;
        this.userResource = userResource;
        this.deployitServers = deployitServers;
        this.permissions = permissions;
        this.internalSecurityProxy = internalSecurityProxy;
        this.userProfiles = userProfiles;
    }

    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @POST
    public void createEntities(List<ConfigurationItem> entities) {
        this.permissions.check(PlatformPermissions.ADMIN);
        this.repositoryService.create(entities.toArray(new ConfigurationItem[entities.size()]));
        this.userProfiles.clearCache();
    }

    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @PUT
    public void updateEntities(List<ConfigurationItem> entities) {
        this.permissions.check(PlatformPermissions.ADMIN);
        this.repositoryService.createOrUpdate(entities.toArray(new ConfigurationItem[entities.size()]));
        this.userProfiles.clearCache();
    }

    @DELETE
    public void deleteReleases() {
        this.permissions.check(PlatformPermissions.ADMIN);
        this.deleteAll(Release.class);
    }

    private void deleteAll(Class<? extends ConfigurationItem> ciClass) {
        this.permissions.check(PlatformPermissions.ADMIN);
        SearchParameters query = new SearchParameters().setType(Type.valueOf(ciClass));
        List items = this.repositoryService.listEntities(query);
        List ids = Lists.transform((List)items, (Function)new Function<ConfigurationItem, String>(){

            public String apply(ConfigurationItem input) {
                return input.getId();
            }
        });
        this.repositoryService.delete(ids.toArray(new String[ids.size()]));
    }

    @Path(value="{id}")
    @DELETE
    public void deleteApplicationEntity(@PathParam(value="id") @IdParam String id) {
        this.permissions.check(PlatformPermissions.ADMIN);
        this.repositoryService.delete(new String[]{id});
    }

    @Path(value="/configuration/{id}")
    @DELETE
    public void deleteConfigurationDirectory(@PathParam(value="id") String id) {
        this.permissions.check(PlatformPermissions.ADMIN);
        this.repositoryService.delete(new String[]{"Configuration/" + id});
    }

    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Path(value="/servers/")
    @POST
    public void createServers(List<DeployitServerDefinition> deployitServerDefinitions) {
        this.permissions.check(PlatformPermissions.ADMIN);
        for (DeployitServerDefinition deployitServerDefinition : deployitServerDefinitions) {
            this.deployitServers.addServer(deployitServerDefinition);
        }
    }

    @Path(value="/servers/")
    @DELETE
    public void deleteServers() {
        this.permissions.check(PlatformPermissions.ADMIN);
        this.deleteAll(DeployitServerDefinition.class);
    }

    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Path(value="/user")
    @POST
    public void createUser(FixturesUser fixturesUser) {
        this.permissions.check(PlatformPermissions.ADMIN);
        User user = fixturesUser.toUser();
        this.userResource.create(user.getUsername(), user);
    }

    @Path(value="/user/{login}")
    @DELETE
    public void deleteUser(@PathParam(value="login") String login) {
        this.permissions.check(PlatformPermissions.ADMIN);
        this.userResource.delete(login);
    }

    @Path(value="/calendar")
    @DELETE
    public void deleteCalendar() {
        this.repositoryService.delete(new String[]{"/Configuration/Calendar"});
    }

    @Path(value="/cis")
    @DELETE
    public void deleteCIs(List<ConfigurationItem> cis) {
        this.permissions.check(PlatformPermissions.ADMIN);
        for (ConfigurationItem ci : cis) {
            this.repositoryService.delete(new String[]{ci.getId()});
        }
        this.userProfiles.clearCache();
    }

    @Path(value="/userProfile")
    @GET
    public Response searchUserProfile(@QueryParam(value="name") String username, @QueryParam(value="email") String userEmail, @QueryParam(value="fullName") String fullName) {
        this.permissions.check(PlatformPermissions.ADMIN);
        String id = USER_PATH + username;
        if (!this.repositoryService.exists(id)) {
            return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
        }
        UserProfile profile = (UserProfile)this.repositoryService.read(id);
        boolean sameEmail = Objects.equals(profile.getEmail(), userEmail);
        boolean sameFullName = Objects.equals(profile.getFullName(), fullName);
        return sameEmail && sameFullName ? Response.ok().build() : Response.status((Response.Status)Response.Status.NOT_FOUND).build();
    }

    @Path(value="/expectContainingAttachments/{releaseId}")
    @POST
    @Workdir
    public Response expectContainingAttachments(@PathParam(value="releaseId") @IdParam String releaseId, ExpectedAttachment expectedAttachment) throws IOException {
        this.permissions.check(PlatformPermissions.ADMIN);
        Release release = (Release)this.repositoryService.read(releaseId, WorkdirHolder.get());
        for (Attachment attachment : release.getAttachments()) {
            OverthereFile file = attachment.getFile();
            if (!file.getName().equals(expectedAttachment.getName())) continue;
            return this.checkContent(expectedAttachment, file);
        }
        throw new Error("Attachment not found");
    }

    private Response checkContent(ExpectedAttachment expectedAttachment, OverthereFile file) throws IOException {
        Throwable throwable = null;
        try (InputStream inputStream = file.getInputStream();){
            ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
            FileCopyUtils.copy((InputStream)inputStream, (OutputStream)outputStream);
            String content = outputStream.toString(Charsets.UTF_8.name());
            if (content.equals(expectedAttachment.getExpectedContent())) {
                Response response = Response.ok().build();
                return response;
            }
            try {
                throw new Error("Expected content to be " + expectedAttachment.getExpectedContent() + " content found : " + content);
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
        }
    }

    @POST
    @Path(value="roles/permissions/{id:.*?}")
    public void writeRolePermissions(@PathParam(value="id") String id, List<RolePermissionsView> rolePermissionsViews) {
        this.permissions.check(PlatformPermissions.ADMIN);
        List permissions = Lists.transform(rolePermissionsViews, (Function)new Function<RolePermissionsView, RolePermissions>(){

            public RolePermissions apply(RolePermissionsView input) {
                return input.toRolePermissions();
            }
        });
        this.internalSecurityProxy.writeRolePermissions(id, permissions);
    }

    @POST
    @Path(value="roles/principals")
    public void writeRolePrincipals(List<RolePrincipalsView> rolePrincipalsViews) {
        this.permissions.check(PlatformPermissions.ADMIN);
        List rolePrincipals = Lists.transform(rolePrincipalsViews, RolePrincipalsView.TO_ROLE_PRINCIPAL);
        this.internalSecurityProxy.writeRolePrincipals(rolePrincipals);
    }

    public static class ExpectedAttachment {
        private String name;
        private String expectedContent;

        public String getName() {
            return this.name;
        }

        public String getExpectedContent() {
            return this.expectedContent;
        }
    }
}

