/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.api;

import com.google.common.base.Preconditions;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.io.ByteStreams;
import com.xebialabs.deployit.core.rest.resteasy.Workdir;
import com.xebialabs.deployit.core.rest.resteasy.WorkdirHolder;
import com.xebialabs.deployit.exception.NotFoundException;
import com.xebialabs.deployit.plumbing.ExtendedRepositoryService;
import com.xebialabs.deployit.plumbing.id.IdParam;
import com.xebialabs.deployit.repository.RepositoryService;
import com.xebialabs.deployit.repository.WorkDir;
import com.xebialabs.xlrelease.api.ReportResource;
import com.xebialabs.xlrelease.api.Transfer;
import com.xebialabs.xlrelease.domain.Attachment;
import com.xebialabs.xlrelease.domain.Release;
import com.xebialabs.xlrelease.excel.ReleaseExcel;
import com.xebialabs.xlrelease.excel.ReportExcel;
import com.xebialabs.xlrelease.export.TemplateExporter;
import com.xebialabs.xlrelease.repository.Attachments;
import com.xebialabs.xlrelease.repository.Ids;
import com.xebialabs.xlrelease.security.PermissionChecker;
import com.xebialabs.xlrelease.views.TimeFrame;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Date;
import java.util.List;
import java.util.concurrent.TimeUnit;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.StreamingOutput;
import org.apache.poi.ss.usermodel.Workbook;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;

@Path(value="/export")
@Controller
public class ExportResource {
    public static final String ZIP_FORMAT = "zip";
    private static final String ICS_CONTENT_TYPE = "text/calendar";
    private static final String ICS_EXTENSION = ".ics";
    private static final String EXCEL_CONTENT_TYPE = "application/vnd.ms-excel";
    private static final String EXCEL_EXTENSION = ".xlsx";
    private static final String XLR_EXTENSION = ".xlr";
    private static final String APPLICATION_ZIP_MEDIA_TYPE = "application/zip";
    private final Cache<String, ReleaseDownload> releaseDownloadCache = CacheBuilder.newBuilder().expireAfterWrite(1L, TimeUnit.MINUTES).build();
    private final Cache<String, AttachmentDownload> attachmentDownloadCache = CacheBuilder.newBuilder().expireAfterWrite(1L, TimeUnit.MINUTES).build();
    private final Cache<String, TemplateExport> templateExportCache = CacheBuilder.newBuilder().expireAfterWrite(1L, TimeUnit.MINUTES).build();
    private final Cache<String, ReportExport> reportExportCache = CacheBuilder.newBuilder().expireAfterWrite(1L, TimeUnit.MINUTES).build();
    private ReportExcel reportExcel;
    private ExtendedRepositoryService extendedRepositoryService;
    private PermissionChecker permissions;
    private Attachments attachments;
    private TemplateExporter templateExporter;
    private RepositoryService repositoryService;

    @Autowired
    public ExportResource(ReportExcel reportExcel, ExtendedRepositoryService extendedRepositoryService, PermissionChecker permissions, Attachments attachments, TemplateExporter templateExporter, RepositoryService repositoryService) {
        this.reportExcel = reportExcel;
        this.extendedRepositoryService = extendedRepositoryService;
        this.permissions = permissions;
        this.attachments = attachments;
        this.templateExporter = templateExporter;
        this.repositoryService = repositoryService;
    }

    public String registerExport(String releaseId, String format) {
        Transfer export = format.equals(ZIP_FORMAT) ? this.registerTemplateExport(releaseId) : this.registerReleaseDownload(releaseId);
        return export.getKey();
    }

    private Transfer registerReleaseDownload(String releaseId) {
        Release release = (Release)this.extendedRepositoryService.read(releaseId);
        ReleaseDownload releaseDownload = new ReleaseDownload(release);
        this.releaseDownloadCache.put((Object)releaseDownload.getKey(), (Object)releaseDownload);
        return releaseDownload;
    }

    private Transfer registerTemplateExport(String templateId) {
        TemplateExport templateExport = new TemplateExport(templateId);
        this.templateExportCache.put((Object)templateExport.getKey(), (Object)templateExport);
        return templateExport;
    }

    public String registerReport(ReportResource.ReportType report, TimeFrame timeFrame, List<String> tags, Date from, Date to) {
        ReportExport export = new ReportExport(report, timeFrame, tags, from, to);
        this.reportExportCache.put((Object)export.getKey(), (Object)export);
        return export.getKey();
    }

    @GET
    @Path(value="attachments/register/{attachmentId}")
    public Response registerAttachmentDownload(@PathParam(value="attachmentId") @IdParam String attachmentId) {
        this.permissions.checkView(Ids.releaseIdFrom(attachmentId));
        AttachmentDownload attachmentDownload = new AttachmentDownload(attachmentId);
        this.attachmentDownloadCache.put((Object)attachmentDownload.getKey(), (Object)attachmentDownload);
        return Response.ok((Object)attachmentDownload.getKey()).build();
    }

    @GET
    @Workdir
    @Path(value="attachments/download/{downloadkey}")
    @Produces(value={"application/octet-stream"})
    public Response downloadAttachment(@PathParam(value="downloadkey") String downloadKey) {
        AttachmentDownload attachmentToDownload = this.getAttachmentToDownload(downloadKey);
        final Attachment attachment = this.attachments.findById(attachmentToDownload.attachmentId);
        final WorkDir workDir = WorkdirHolder.get();
        StreamingOutput output = new StreamingOutput(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void write(OutputStream output) throws IOException, WebApplicationException {
                try (InputStream inputStream = attachment.getFile().getInputStream();){
                    ByteStreams.copy((InputStream)inputStream, (OutputStream)output);
                }
                finally {
                    workDir.delete();
                }
            }
        };
        String fileName = attachment.getFile().getName();
        return this.streamFile(fileName, output, attachment.getContentType());
    }

    @GET
    @Path(value="/calendar/{downloadkey}")
    @Produces(value={"application/octet-stream"})
    public Response exportReleaseToCalendar(@PathParam(value="downloadkey") String downloadKey) {
        Release release = this.getReleaseToDownload(downloadKey);
        final String calendarContent = release.toICS();
        StreamingOutput output = new StreamingOutput(){

            public void write(OutputStream output) throws IOException, WebApplicationException {
                output.write(calendarContent.getBytes("UTF-8"));
            }
        };
        String fileName = release.getTitle() + ICS_EXTENSION;
        return this.streamFile(fileName, output, ICS_CONTENT_TYPE);
    }

    @GET
    @Path(value="/excel/{downloadkey}")
    @Produces(value={"application/octet-stream"})
    public Response exportReleaseToExcel(@PathParam(value="downloadkey") String downloadKey) {
        Release release = this.getReleaseToDownload(downloadKey);
        final Workbook workbook = new ReleaseExcel(release).getWorkBook();
        StreamingOutput output = new StreamingOutput(){

            public void write(OutputStream output) throws IOException, WebApplicationException {
                workbook.write(output);
            }
        };
        String fileName = release.getTitle() + EXCEL_EXTENSION;
        return this.streamFile(fileName, output, EXCEL_CONTENT_TYPE);
    }

    @GET
    @Path(value="/report/{downloadkey}")
    @Produces(value={"application/octet-stream"})
    public Response exportReportToExcel(@PathParam(value="downloadkey") String downloadKey) {
        ReportExport export = this.getReportToExport(downloadKey);
        final Workbook workbook = this.reportExcel.getWorkBook(export.report, export.timeFrame, export.tags, export.from, export.to);
        StreamingOutput output = new StreamingOutput(){

            public void write(OutputStream output) throws IOException, WebApplicationException {
                workbook.write(output);
            }
        };
        String fileName = export.report.name().toLowerCase() + EXCEL_EXTENSION;
        return this.streamFile(fileName, output, EXCEL_CONTENT_TYPE);
    }

    @GET
    @Workdir
    @Path(value="/zip/{downloadkey}")
    @Produces(value={"application/octet-stream"})
    public Response exportTemplateToZip(@PathParam(value="downloadkey") String downloadKey) {
        final WorkDir workDir = WorkdirHolder.get();
        final Release release = (Release)this.repositoryService.read(this.getTemplateIdToExport(downloadKey), workDir, false);
        Preconditions.checkArgument((boolean)release.isTemplate(), (Object)"Only templates can be exported.");
        StreamingOutput output = new StreamingOutput(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void write(OutputStream output) throws IOException, WebApplicationException {
                try {
                    ExportResource.this.templateExporter.exportTemplate(release, output);
                }
                finally {
                    workDir.delete();
                }
            }
        };
        String fileName = release.getTitle() + XLR_EXTENSION;
        return this.streamFile(fileName, output, APPLICATION_ZIP_MEDIA_TYPE);
    }

    private Release getReleaseToDownload(String downloadKey) {
        ReleaseDownload download = (ReleaseDownload)this.releaseDownloadCache.getIfPresent((Object)downloadKey);
        if (download == null) {
            throw new NotFoundException("The download with key [%s] was not found.", new Object[]{downloadKey});
        }
        this.releaseDownloadCache.invalidate((Object)downloadKey);
        return download.release;
    }

    private String getTemplateIdToExport(String downloadKey) {
        TemplateExport export = (TemplateExport)this.templateExportCache.getIfPresent((Object)downloadKey);
        if (export == null) {
            throw new NotFoundException("The export with key [%s] was not found.", new Object[]{downloadKey});
        }
        this.releaseDownloadCache.invalidate((Object)downloadKey);
        return export.templateId;
    }

    private ReportExport getReportToExport(String downloadKey) {
        ReportExport export = (ReportExport)this.reportExportCache.getIfPresent((Object)downloadKey);
        if (export == null) {
            throw new NotFoundException("The export with key [%s] was not found.", new Object[]{downloadKey});
        }
        this.reportExportCache.invalidate((Object)downloadKey);
        return export;
    }

    private AttachmentDownload getAttachmentToDownload(String downloadKey) {
        AttachmentDownload attachment = (AttachmentDownload)this.attachmentDownloadCache.getIfPresent((Object)downloadKey);
        if (attachment == null) {
            throw new NotFoundException("The attachment with key [%s] was not found.", new Object[]{downloadKey});
        }
        this.reportExportCache.invalidate((Object)downloadKey);
        return attachment;
    }

    private Response streamFile(String fileName, StreamingOutput output, String contentType) {
        return Response.ok((Object)output, (String)contentType).header("Content-Disposition", (Object)String.format("attachment; filename=\"%s\"", fileName)).build();
    }

    private static class ReportExport
    extends Transfer {
        private final ReportResource.ReportType report;
        private final TimeFrame timeFrame;
        private final List<String> tags;
        private final Date from;
        private final Date to;

        ReportExport(ReportResource.ReportType report, TimeFrame timeFrame, List<String> tags, Date from, Date to) {
            this.report = report;
            this.timeFrame = timeFrame;
            this.tags = tags;
            this.from = from;
            this.to = to;
        }
    }

    private static class TemplateExport
    extends Transfer {
        private final String templateId;

        TemplateExport(String templateId) {
            this.templateId = templateId;
        }
    }

    private static class AttachmentDownload
    extends Transfer {
        private final String attachmentId;

        public AttachmentDownload(String attachmentId) {
            this.attachmentId = attachmentId;
        }
    }

    private static class ReleaseDownload
    extends Transfer {
        private final Release release;

        ReleaseDownload(Release release) {
            this.release = release;
        }
    }
}

