/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.api;

import com.google.common.annotations.VisibleForTesting;
import com.xebialabs.deployit.plumbing.CurrentVersion;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.core.Response;
import org.springframework.stereotype.Controller;

@Path(value="/documentation")
@Controller
public class DocumentationLinkResource {
    private static final Pattern MAJOR_MINOR_VERSION_PATTERN = Pattern.compile("(\\d+\\.\\d+).*");
    private final String version;

    public DocumentationLinkResource() {
        this.version = CurrentVersion.get();
    }

    @VisibleForTesting
    DocumentationLinkResource(String version) {
        this.version = version;
    }

    @GET
    public Response redirectToDocumentation() throws MalformedURLException, URISyntaxException {
        return Response.seeOther((URI)new URL("http", "docs.xebialabs.com", this.getFilePart()).toURI()).build();
    }

    @GET
    @Path(value="{path:.*?}")
    public Response redirectToDocumentation(@PathParam(value="path") String path) throws MalformedURLException, URISyntaxException {
        return Response.seeOther((URI)new URL("http", "docs.xebialabs.com", this.getFilePart() + path).toURI()).build();
    }

    private String getFilePart() {
        Matcher matcher = MAJOR_MINOR_VERSION_PATTERN.matcher(this.version);
        if (matcher.find()) {
            String mainVersion = matcher.group(1);
            return "/releases/" + mainVersion + "/xl-release/";
        }
        return "/xl-release/";
    }
}

