/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.api;

import com.google.common.base.Preconditions;
import com.xebialabs.deployit.plumbing.id.IdParam;
import com.xebialabs.xlrelease.concurrent.ReleaseIdHolder;
import com.xebialabs.xlrelease.concurrent.Synchronized;
import com.xebialabs.xlrelease.domain.Task;
import com.xebialabs.xlrelease.repository.Comments;
import com.xebialabs.xlrelease.repository.Ids;
import com.xebialabs.xlrelease.repository.Tasks;
import com.xebialabs.xlrelease.repository.UserProfiles;
import com.xebialabs.xlrelease.security.PermissionChecker;
import com.xebialabs.xlrelease.views.CommentView;
import javax.ws.rs.Consumes;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;

@Path(value="/comments")
@Consumes(value={"application/json"})
@Produces(value={"application/json"})
@Controller
public class CommentResource {
    private Comments comments;
    private Tasks tasks;
    private PermissionChecker permissions;
    private UserProfiles userProfiles;

    @Autowired
    public CommentResource(Comments comments, Tasks tasks, PermissionChecker permissions, UserProfiles userProfiles) {
        this.comments = comments;
        this.tasks = tasks;
        this.permissions = permissions;
        this.userProfiles = userProfiles;
    }

    public CommentResource() {
    }

    @PUT
    @Path(value="{commentId}")
    @Synchronized
    public CommentView updateComment(@PathParam(value="commentId") @IdParam @ReleaseIdHolder String commentId, CommentView commentView) {
        this.permissions.checkEditTask(Ids.releaseIdFrom(commentId));
        Task task = this.tasks.findById(Ids.getParentId(commentId));
        Preconditions.checkArgument((boolean)task.isUpdatable(), (Object)"Comments on finished tasks can't be updated.");
        return new CommentView(this.comments.update(commentId, commentView.getText()), this.userProfiles);
    }
}

