/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.activity;

import com.google.common.collect.ImmutableSortedSet;
import com.google.common.collect.Sets;
import com.xebialabs.xlrelease.domain.ActivityLogEntry;
import com.xebialabs.xlrelease.domain.ReleaseActivity;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;

public class ReleaseVariablesComparator {
    private final Map<String, String> before;
    private final Map<String, String> after;

    public ReleaseVariablesComparator(Map<String, String> before, Map<String, String> after) {
        this.before = before == null ? Collections.emptyMap() : before;
        this.after = after == null ? Collections.emptyMap() : after;
    }

    public ActivityLogEntry getLogEntry() {
        ImmutableSortedSet addedKeys = ImmutableSortedSet.copyOf((Collection)Sets.difference(this.after.keySet(), this.before.keySet()));
        ImmutableSortedSet commonKeys = ImmutableSortedSet.copyOf((Collection)Sets.intersection(this.before.keySet(), this.after.keySet()));
        StringWriter rawWriter = new StringWriter();
        PrintWriter writer = new PrintWriter(rawWriter);
        for (String key : addedKeys) {
            writer.printf("- added %s = '%s'\n", key, this.after.get(key));
        }
        for (String key : commonKeys) {
            if (this.before.get(key).equals(this.after.get(key))) continue;
            writer.printf("- changed %s from '%s' to '%s'\n", key, this.before.get(key), this.after.get(key));
        }
        String logs = rawWriter.toString();
        return logs.isEmpty() ? null : ReleaseActivity.RELEASE_VARIABLES_UPDATED.create(logs);
    }
}

