/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.activity;

import com.google.common.base.Objects;
import com.google.common.collect.Lists;
import com.google.common.primitives.Ints;
import com.xebialabs.xlrelease.activity.DurationFormatter;
import com.xebialabs.xlrelease.activity.ReleaseActivityFormatter;
import com.xebialabs.xlrelease.domain.ActivityLogEntry;
import com.xebialabs.xlrelease.domain.Phase;
import com.xebialabs.xlrelease.domain.ReleaseActivity;
import com.xebialabs.xlrelease.views.PhaseForm;
import java.util.ArrayList;
import java.util.List;

public class PhaseFieldsComparator {
    private Phase original;
    private PhaseForm updated;

    public PhaseFieldsComparator(Phase original, PhaseForm updated) {
        this.original = original;
        this.updated = updated;
    }

    public List<ActivityLogEntry> getLogs() {
        ArrayList logEntries = Lists.newArrayList();
        if (!Objects.equal((Object)this.original.getTitle(), (Object)this.updated.getTitle())) {
            logEntries.add(ReleaseActivity.PHASE_RENAMED.create(this.original.getTitle(), this.updated.getTitle()));
        }
        if (!Objects.equal((Object)this.original.getDescription(), (Object)this.updated.getDescription())) {
            logEntries.add(ReleaseActivity.PHASE_DESCRIPTION_UPDATED.create(this.updated.getTitle(), this.original.getDescription(), this.updated.getDescription()));
        }
        if (!Objects.equal((Object)this.original.getDueDate(), (Object)this.updated.getDueDate())) {
            logEntries.add(ReleaseActivity.PHASE_DUE_DATE_UPDATED.create(this.updated.getTitle(), ReleaseActivityFormatter.formatDate(this.original.getDueDate()), ReleaseActivityFormatter.formatDate(this.updated.getDueDate())));
        }
        if (!Objects.equal((Object)this.original.getScheduledStartDate(), (Object)this.updated.getScheduledStartDate())) {
            logEntries.add(ReleaseActivity.PHASE_SCHEDULED_START_DATE_UPDATED.create(this.updated.getTitle(), ReleaseActivityFormatter.formatDate(this.original.getScheduledStartDate()), ReleaseActivityFormatter.formatDate(this.updated.getScheduledStartDate())));
        }
        if (!Objects.equal((Object)this.original.getColor(), (Object)this.updated.getColor())) {
            logEntries.add(ReleaseActivity.PHASE_COLOR_CHANGED.create(this.updated.getTitle(), this.original.getColor(), this.updated.getColor()));
        }
        Integer newDuration = null;
        if (this.updated.getPlannedDuration() != null) {
            newDuration = Ints.checkedCast((long)(this.updated.getPlannedDuration() / 1000L));
        }
        if (!Objects.equal((Object)this.original.getPlannedDuration(), newDuration)) {
            logEntries.add(ReleaseActivity.PHASE_DURATION_UPDATED.create(this.updated.getTitle(), DurationFormatter.formatDuration(this.original.getPlannedDuration()), DurationFormatter.formatDuration(newDuration)));
        }
        return logEntries;
    }
}

