/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease;

import com.google.common.base.Strings;
import com.xebialabs.deployit.CustomErrorHandler;
import com.xebialabs.deployit.ServerConfiguration;
import com.xebialabs.deployit.booter.local.LocalBooter;
import com.xebialabs.deployit.core.rest.resteasy.Mime4jStorageProvider;
import com.xebialabs.deployit.engine.spi.event.SystemStartedEvent;
import com.xebialabs.deployit.event.EventBusHolder;
import com.xebialabs.deployit.event.ShutdownEvent;
import com.xebialabs.deployit.jetty.DeployitSpringContextLoaderListener;
import com.xebialabs.deployit.plumbing.ApplicationContextHolder;
import com.xebialabs.deployit.plumbing.LogbackFilter;
import com.xebialabs.deployit.plumbing.VersionEnforcerFilter;
import com.xebialabs.xlrelease.Environment;
import com.xebialabs.xlrelease.license.RepositoryIdService;
import com.xebialabs.xlrelease.license.XLReleaseLicenseService;
import com.xebialabs.xlrelease.wro.WroFilter;
import java.util.EnumSet;
import java.util.EventListener;
import java.util.concurrent.CountDownLatch;
import javax.servlet.DispatcherType;
import nl.javadude.t2bus.Subscribe;
import org.apache.james.mime4j.storage.DefaultStorageProvider;
import org.apache.james.mime4j.storage.StorageProvider;
import org.eclipse.jetty.security.ConstraintSecurityHandler;
import org.eclipse.jetty.security.SecurityHandler;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.HandlerContainer;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.ServerConnector;
import org.eclipse.jetty.server.handler.ErrorHandler;
import org.eclipse.jetty.server.session.SessionHandler;
import org.eclipse.jetty.servlet.FilterHolder;
import org.eclipse.jetty.servlet.ServletHandler;
import org.eclipse.jetty.servlet.ServletHolder;
import org.eclipse.jetty.util.ssl.SslContextFactory;
import org.eclipse.jetty.util.thread.QueuedThreadPool;
import org.eclipse.jetty.util.thread.ThreadPool;
import org.eclipse.jetty.webapp.WebAppContext;
import org.jboss.resteasy.plugins.server.servlet.HttpServletDispatcher;
import org.jboss.resteasy.plugins.server.servlet.ResteasyBootstrap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.filter.DelegatingFilterProxy;

public class XLReleaseServer {
    private static final String SPRING_CTX_CFG_LOCATION_KEY = "contextConfigLocation";
    private final ServerConfiguration serverConfiguration;
    private final String name;
    private final String springConfig;
    private Server jettyServer;
    private WebAppContext contextRoot;
    private static volatile CountDownLatch shutdownLatch = new CountDownLatch(1);
    private static final Logger logger = LoggerFactory.getLogger(XLReleaseServer.class);

    public XLReleaseServer(String name, ServerConfiguration configuration, String springConfig, String contextPath) {
        this.serverConfiguration = configuration;
        this.name = name;
        this.springConfig = springConfig;
        this.setupJetty(contextPath);
        XLReleaseServer.bootPlugins();
        this.setupSpring();
        this.setupRest();
        this.setupWro4J();
        this.setupVersionEnforcer();
        this.setupLogbackFilter();
    }

    private void setupJetty(String contextPath) {
        int port = this.serverConfiguration.getHttpPort();
        String documentRootPackage = "web";
        if (logger.isDebugEnabled()) {
            logger.debug("Setting up Jetty server on port {} with context root {} using package {} for document root.", new Object[]{port, this.contextRoot, documentRootPackage});
        }
        this.jettyServer = new Server((ThreadPool)this.buildThreadPool());
        ServerConnector connector = this.serverConfiguration.isSsl() ? this.setupSSL() : new ServerConnector(this.jettyServer);
        connector.setIdleTimeout(30000L);
        connector.setHost(this.serverConfiguration.getHttpBindAddress());
        connector.setPort(port);
        this.jettyServer.addConnector((Connector)connector);
        this.jettyServer.setStopTimeout(1000L);
        this.contextRoot = new WebAppContext((HandlerContainer)this.jettyServer, contextPath, new SessionHandler(), (SecurityHandler)new ConstraintSecurityHandler(), new ServletHandler(), (ErrorHandler)new CustomErrorHandler(), 0);
    }

    private ServerConnector setupSSL() {
        logger.debug("Setting up Jetty to use SSL");
        SslContextFactory sslContextFactory = new SslContextFactory();
        sslContextFactory.setKeyStorePath(this.serverConfiguration.getKeyStorePath());
        sslContextFactory.setKeyStorePassword(this.serverConfiguration.getKeyStorePassword());
        sslContextFactory.setKeyManagerPassword(this.serverConfiguration.getKeyStoreKeyPassword());
        String protocol = this.serverConfiguration.getSslProtocol();
        if (!Strings.nullToEmpty((String)protocol).trim().isEmpty()) {
            sslContextFactory.setProtocol(protocol);
        }
        return new ServerConnector(this.jettyServer, sslContextFactory);
    }

    private QueuedThreadPool buildThreadPool() {
        return new QueuedThreadPool(this.serverConfiguration.getMaxThreads(), this.serverConfiguration.getMinThreads());
    }

    private static void bootPlugins() {
        LocalBooter.boot();
    }

    private void setupSpring() {
        ServerConfiguration.setInstance((ServerConfiguration)this.serverConfiguration);
        this.contextRoot.getInitParams().put(SPRING_CTX_CFG_LOCATION_KEY, this.springConfig);
        if (logger.isDebugEnabled()) {
            logger.debug("Using Spring configuration - " + this.springConfig);
        }
        FilterHolder filter = new FilterHolder(DelegatingFilterProxy.class);
        filter.setName("springSecurityFilterChain");
        this.contextRoot.addFilter(filter, "/*", EnumSet.of(DispatcherType.REQUEST));
    }

    private void setupRest() {
        this.contextRoot.addEventListener((EventListener)new ResteasyBootstrap());
        this.contextRoot.addEventListener((EventListener)new DeployitSpringContextLoaderListener());
        ServletHolder servletHolder = new ServletHolder(HttpServletDispatcher.class);
        this.contextRoot.getInitParams().put("resteasy.servlet.mapping.prefix", "/");
        this.contextRoot.getInitParams().put("resteasy.document.expand.entity.references", "false");
        this.contextRoot.addServlet(servletHolder, "/*");
        this.contextRoot.setResourceBase(".");
        DefaultStorageProvider.setInstance((StorageProvider)new Mime4jStorageProvider());
    }

    private void setupWro4J() {
        if (Environment.isDevelopment()) {
            this.contextRoot.addFilter(WroFilter.class, "/static/*", EnumSet.of(DispatcherType.REQUEST));
        }
    }

    private void setupVersionEnforcer() {
        this.contextRoot.addFilter(VersionEnforcerFilter.class, "/*", EnumSet.of(DispatcherType.REQUEST));
    }

    private void setupLogbackFilter() {
        this.contextRoot.addFilter(LogbackFilter.class, "/*", EnumSet.of(DispatcherType.REQUEST));
    }

    public void start() {
        try {
            if (logger.isDebugEnabled()) {
                logger.debug("Starting Jetty");
            }
            this.jettyServer.start();
            DeployitSpringContextLoaderListener.checkCorrectlyInitialized();
            this.checkRepositoryLicense();
            logger.info("{} has started.", (Object)this.name);
            this.createShutdownEventThreadAndShutdownHook();
            logger.info("You can now point your browser to {}", (Object)this.serverConfiguration.getServerUrl());
            EventBusHolder.publish((Object)new SystemStartedEvent());
        }
        catch (Exception e) {
            logger.error("Error occured while starting Jetty", (Throwable)e);
            this.stop();
        }
    }

    private synchronized void stop() {
        if (this.jettyServer.isRunning()) {
            logger.info("Shutting down {}.", (Object)this.name);
            try {
                this.jettyServer.stop();
                logger.info("{} has shut down.", (Object)this.name);
            }
            catch (Exception e) {
                logger.error("Error occurred while trying to stop Jetty", (Throwable)e);
            }
        }
    }

    private void createShutdownEventThreadAndShutdownHook() {
        Thread shutdownEventThread = new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    shutdownLatch.await();
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                }
                logger.trace("Shutting down {} because a shutdown event was received.", (Object)XLReleaseServer.this.name);
                XLReleaseServer.this.stop();
            }
        });
        shutdownEventThread.start();
        Runtime.getRuntime().addShutdownHook(new Thread(new Runnable(){

            @Override
            public void run() {
                logger.trace("Shutting down {} because the process is being terminated.", (Object)XLReleaseServer.this.name);
                XLReleaseServer.this.stop();
            }
        }));
        EventBusHolder.register((Object)this);
    }

    public WebAppContext getContext() {
        return this.contextRoot;
    }

    @Subscribe
    public void shutdownListener(ShutdownEvent event) {
        logger.trace("Received shutdown event.");
        shutdownLatch.countDown();
    }

    private void checkRepositoryLicense() {
        RepositoryIdService repositoryLicense = ApplicationContextHolder.getBean(RepositoryIdService.class);
        String storedRepositoryId = repositoryLicense.fetchRepositoryId();
        XLReleaseLicenseService licenseService = ApplicationContextHolder.getBean(XLReleaseLicenseService.class);
        licenseService.checkLicenseAtStartup(storedRepositoryId);
    }
}

