/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease;

import java.io.File;

public class Environment {
    public static final File WEB_PATH = new File("../../web/");
    public static final File BUILTIN_PLUGINS_PATH = new File("../../main/resources/");
    public static final String DEFAULT_SPRING_CONFIG = "classpath:spring/xlrelease-context.xml,classpath:xl-release-security.xml,classpath*:hotfix-context.xml";
    public static final String DEVMODE = "RELEASEITDEVMODE";

    public static boolean isProduction() {
        return System.getenv(DEVMODE) == null;
    }

    public static boolean isDevelopment() {
        return !Environment.isProduction();
    }

    public static String getSpringConfig() {
        String springSecurityFile = System.getenv("SPRING_SECURITY_FILE");
        if (springSecurityFile == null) {
            return DEFAULT_SPRING_CONFIG;
        }
        return DEFAULT_SPRING_CONFIG.replace("xl-release-security.xml", springSecurityFile);
    }

    public static File getWebPath() {
        return WEB_PATH;
    }

    public static File getBuiltinPluginsPath() {
        return BUILTIN_PLUGINS_PATH;
    }

    private Environment() {
    }
}

