/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.plumbing.licenses;

import com.google.common.base.Preconditions;
import com.xebialabs.xlrelease.license.XLReleaseLicenseService;
import java.io.IOException;
import java.util.List;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.web.util.AntPathRequestMatcher;

public class LicenseCheckFilter
implements Filter {
    private static final Logger log = LoggerFactory.getLogger(LicenseCheckFilter.class);
    private XLReleaseLicenseService licenseService;
    private List<String> unprotectedUrls;

    @Autowired
    public LicenseCheckFilter(XLReleaseLicenseService licenseService, List<String> unprotectedUrls) {
        this.licenseService = licenseService;
        this.unprotectedUrls = unprotectedUrls;
    }

    public void init(FilterConfig filterConfig) throws ServletException {
        log.trace("Added LicenseCheckFilter to the mix.");
        Preconditions.checkNotNull((Object)this.licenseService, (Object)"LicenseCheckFilter: Could not find license check service");
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        if (!(request instanceof HttpServletRequest) || !(response instanceof HttpServletResponse)) {
            chain.doFilter(request, response);
            return;
        }
        if (this.isUrlProtected((HttpServletRequest)request) && !this.licenseService.isLicenseValid()) {
            HttpServletResponse hsr = (HttpServletResponse)response;
            hsr.sendError(402, "License expired");
        } else {
            chain.doFilter(request, response);
        }
    }

    private boolean isUrlProtected(HttpServletRequest request) {
        for (String checkedUrl : this.unprotectedUrls) {
            AntPathRequestMatcher matcher = new AntPathRequestMatcher(checkedUrl);
            if (!matcher.matches(request)) continue;
            return false;
        }
        return true;
    }

    public void destroy() {
    }
}

