/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.plumbing;

import com.xebialabs.deployit.ServerConfiguration;
import com.xebialabs.deployit.UnhandledExceptionMapper;
import java.util.Date;
import javax.ws.rs.core.Response;
import javax.ws.rs.ext.ExceptionMapper;
import javax.ws.rs.ext.Provider;
import org.jboss.resteasy.spi.Failure;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Provider
@Component
public class UnhandledExceptionMapperProvider
extends UnhandledExceptionMapper
implements ExceptionMapper<RuntimeException> {
    private static final Logger logger = LoggerFactory.getLogger(UnhandledExceptionMapperProvider.class);

    @Autowired
    public UnhandledExceptionMapperProvider(ServerConfiguration config) {
        super(config);
    }

    protected Response handleException(RuntimeException runtimeException) {
        if (runtimeException instanceof Failure) {
            logger.warn(runtimeException.getMessage());
            return ((Failure)runtimeException).getResponse();
        }
        Response response = super.handleException(runtimeException);
        response.getMetadata().add((Object)"Date", (Object)new Date());
        return response;
    }
}

