/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.plumbing;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Charsets;
import com.xebialabs.deployit.plumbing.id.IdType;
import com.xebialabs.xlrelease.views.ImportResult;
import com.xebialabs.xltype.serialization.json.JsonWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.lang.annotation.Annotation;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Collection;
import javax.ws.rs.Produces;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.ext.MessageBodyWriter;
import javax.ws.rs.ext.Provider;
import org.springframework.stereotype.Component;

@Component
@Provider
@Produces(value={"application/json", "text/html"})
public class ImportResultsJsonWriter
implements MessageBodyWriter<Collection<ImportResult>> {
    public boolean isWriteable(Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        if (Collection.class.isAssignableFrom(type) && genericType instanceof ParameterizedType) {
            type = (Class)((ParameterizedType)genericType).getActualTypeArguments()[0];
        }
        return ImportResult.class.isAssignableFrom(type);
    }

    public long getSize(Collection<ImportResult> importResults, Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        return -1L;
    }

    public void writeTo(Collection<ImportResult> importResults, Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType, MultivaluedMap<String, Object> httpHeaders, OutputStream entityStream) throws IOException, WebApplicationException {
        entityStream.write(this.toJson(importResults).getBytes(Charsets.UTF_8));
    }

    @VisibleForTesting
    String toJson(Collection<ImportResult> importResults) {
        StringWriter stringWriter = new StringWriter();
        JsonWriter writer = new JsonWriter((Writer)stringWriter);
        writer.array();
        for (ImportResult importResult : importResults) {
            ImportResultsJsonWriter.writeImportResult(writer, importResult);
        }
        writer.endArray();
        return stringWriter.toString();
    }

    static void writeImportResult(JsonWriter writer, ImportResult importResult) {
        writer.object();
        writer.key("id").value((Object)IdType.DOMAIN.convertToViewId(importResult.getId()));
        writer.key("title").value((Object)importResult.getTitle());
        writer.key("warnings");
        writer.array();
        for (String warning : importResult.getWarnings()) {
            writer.value((Object)warning);
        }
        writer.endArray();
        writer.endObject();
    }
}

