/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pdfbox.pdmodel.font;

import java.io.IOException;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.pdfbox.cos.COSDictionary;
import org.apache.pdfbox.cos.COSName;
import org.apache.pdfbox.pdmodel.font.PDCIDFontType0Font;
import org.apache.pdfbox.pdmodel.font.PDCIDFontType2Font;
import org.apache.pdfbox.pdmodel.font.PDFont;
import org.apache.pdfbox.pdmodel.font.PDMMType1Font;
import org.apache.pdfbox.pdmodel.font.PDSimpleFont;
import org.apache.pdfbox.pdmodel.font.PDTrueTypeFont;
import org.apache.pdfbox.pdmodel.font.PDType0Font;
import org.apache.pdfbox.pdmodel.font.PDType1Font;
import org.apache.pdfbox.pdmodel.font.PDType3Font;

public class PDFontFactory {
    private static final Log LOG = LogFactory.getLog(PDFontFactory.class);

    private PDFontFactory() {
    }

    public static PDFont createFont(COSDictionary dic, Map fontCache) throws IOException {
        return PDFontFactory.createFont(dic);
    }

    public static PDFont createFont(COSDictionary dic) throws IOException {
        PDSimpleFont retval = null;
        COSName type = (COSName)dic.getDictionaryObject(COSName.TYPE);
        if (!type.equals(COSName.FONT)) {
            throw new IOException("Cannot create font if /Type is not /Font.  Actual=" + type);
        }
        COSName subType = (COSName)dic.getDictionaryObject(COSName.SUBTYPE);
        if (subType.equals(COSName.TYPE1)) {
            retval = new PDType1Font(dic);
        } else if (subType.equals(COSName.MM_TYPE1)) {
            retval = new PDMMType1Font(dic);
        } else if (subType.equals(COSName.TRUE_TYPE)) {
            retval = new PDTrueTypeFont(dic);
        } else if (subType.equals(COSName.TYPE3)) {
            retval = new PDType3Font(dic);
        } else if (subType.equals(COSName.TYPE0)) {
            retval = new PDType0Font(dic);
        } else if (subType.equals(COSName.CID_FONT_TYPE0)) {
            retval = new PDCIDFontType0Font(dic);
        } else if (subType.equals(COSName.CID_FONT_TYPE2)) {
            retval = new PDCIDFontType2Font(dic);
        } else {
            LOG.warn((Object)("Substituting TrueType for unknown font subtype=" + dic.getDictionaryObject(COSName.SUBTYPE).toString()));
            retval = new PDTrueTypeFont(dic);
        }
        return retval;
    }
}

