/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.transform.powerassert;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.codehaus.groovy.runtime.DefaultGroovyMethods;
import org.codehaus.groovy.transform.powerassert.Value;
import org.codehaus.groovy.transform.powerassert.ValueRecorder;

public class AssertionRenderer {
    private final String text;
    private final ValueRecorder recorder;
    private final List<StringBuilder> lines = new ArrayList<StringBuilder>();
    private final List<Integer> startColumns = new ArrayList<Integer>();

    private AssertionRenderer(String text, ValueRecorder recorder) {
        if (text.contains("\n")) {
            throw new IllegalArgumentException("source text may not contain line breaks");
        }
        this.text = text;
        this.recorder = recorder;
    }

    public static String render(String text, ValueRecorder recorder) {
        return new AssertionRenderer(text, recorder).render();
    }

    private String render() {
        this.renderText();
        this.sortValues();
        this.renderValues();
        return this.linesToString();
    }

    private void renderText() {
        this.lines.add(new StringBuilder(this.text));
        this.startColumns.add(0);
        this.lines.add(new StringBuilder());
        this.startColumns.add(0);
    }

    private void sortValues() {
        Collections.sort(this.recorder.getValues(), new Comparator<Value>(){

            @Override
            public int compare(Value v1, Value v2) {
                return v2.getColumn() - v1.getColumn();
            }
        });
    }

    private void renderValues() {
        block0: for (Value value : this.recorder.getValues()) {
            int startColumn;
            String str = AssertionRenderer.valueToString(value.getValue());
            if (str == null || (startColumn = value.getColumn()) < 1) continue;
            String[] strs = str.split("\r\n|\r|\n");
            int endColumn = strs.length == 1 ? value.getColumn() + str.length() : Integer.MAX_VALUE;
            for (int i = 1; i < this.lines.size(); ++i) {
                if (endColumn < this.startColumns.get(i)) {
                    AssertionRenderer.placeString(this.lines.get(i), str, startColumn);
                    this.startColumns.set(i, startColumn);
                    continue block0;
                }
                AssertionRenderer.placeString(this.lines.get(i), "|", startColumn);
                if (i <= 1) continue;
                this.startColumns.set(i, startColumn + 1);
            }
            for (String s : strs) {
                StringBuilder newLine = new StringBuilder();
                this.lines.add(newLine);
                AssertionRenderer.placeString(newLine, s, startColumn);
                this.startColumns.add(startColumn);
            }
        }
    }

    private String linesToString() {
        StringBuilder firstLine = this.lines.get(0);
        for (int i = 1; i < this.lines.size(); ++i) {
            firstLine.append('\n').append(this.lines.get(i).toString());
        }
        return firstLine.toString();
    }

    private static void placeString(StringBuilder line, String str, int column) {
        while (line.length() < column) {
            line.append(' ');
        }
        line.replace(column - 1, column - 1 + str.length(), str);
    }

    private static String valueToString(Object value) {
        String toString;
        try {
            toString = DefaultGroovyMethods.toString(value);
        }
        catch (Exception e) {
            return String.format("%s (toString() threw %s)", AssertionRenderer.javaLangObjectToString(value), e.getClass().getName());
        }
        if (toString == null) {
            return String.format("%s (toString() == null)", AssertionRenderer.javaLangObjectToString(value));
        }
        if (toString.equals("")) {
            if (AssertionRenderer.hasStringLikeType(value)) {
                return "\"\"";
            }
            return String.format("%s (toString() == \"\")", AssertionRenderer.javaLangObjectToString(value));
        }
        return toString;
    }

    private static boolean hasStringLikeType(Object value) {
        Class<?> clazz = value.getClass();
        return clazz == String.class || clazz == StringBuffer.class || clazz == StringBuilder.class;
    }

    private static String javaLangObjectToString(Object value) {
        String hash = Integer.toHexString(System.identityHashCode(value));
        return value.getClass().getName() + "@" + hash;
    }
}

