#!/bin/sh
#
# Shell script to start the Deployit Server
#

# Get Java executable
if [ -z "$JAVA_HOME" ] ; then
  JAVACMD=java
else
  JAVACMD="${JAVA_HOME}/bin/java"
fi

# Get JVM options
if [ -z "$XL_RELEASE_SERVER_OPTS" ] ; then
  XL_RELEASE_SERVER_OPTS="-Xmx1024m -XX:MaxPermSize=128m"
fi

# Get logging-related options
if [ -z "$XL_RELEASE_SERVER_LOG_OPTS" ] ; then
  XL_RELEASE_SERVER_LOG_OPTS="-Dlogback.configurationFile=conf/logback.xml -Dderby.stream.error.file=log/derby.log"
fi

# Get Deployit server home dir
if [ -z "$XL_RELEASE_SERVER_HOME" ] ; then
  BIN_DIR=`dirname "$0"`
  cd "$BIN_DIR"
  ABSOLUTE_BIN_DIR=`pwd`
  XL_RELEASE_SERVER_HOME=`dirname "$ABSOLUTE_BIN_DIR"`
elif [ ! -d "$XL_RELEASE_SERVER_HOME" ] ; then
  echo "Directory $XL_RELEASE_SERVER_HOME does not exist"
  exit 1
fi

cd "$XL_RELEASE_SERVER_HOME"

# Build Deployit server classpath
XL_RELEASE_SERVER_CLASSPATH='conf:ext'
for each in `ls hotfix/*.jar lib/*.jar plugins/*.jar 2>/dev/null`
do
  if [ -f $each ]; then
    XL_RELEASE_SERVER_CLASSPATH=${XL_RELEASE_SERVER_CLASSPATH}:${each}
  fi
done

ls plugins/* > /dev/null 2>&1
if [ $? -eq 0 ]; then
  for expandedPluginDir in `ls plugins/*`
  do
    if [ -d $expandedPluginDir ]; then
      XL_RELEASE_SERVER_CLASSPATH=${XL_RELEASE_SERVER_CLASSPATH}:${expandedPluginDir}
    fi
  done
fi

# Run Deployit server
$JAVACMD $XL_RELEASE_SERVER_OPTS $XL_RELEASE_SERVER_LOG_OPTS -classpath "${XL_RELEASE_SERVER_CLASSPATH}" -DReleaseit.WebPath=lib/web com.xebialabs.xlrelease.XLReleaseBootstrapper "$@"
