angular.module('xlrelease').factory('VariablesService', [function () {
    function hasPackages(variables) {
        return _.any(variables, function (variable) {
            return variable.type === 'DEPLOYIT_PACKAGE';
        });
    }

    function hasEnvironments(variables) {
        return _.any(variables, function (variable) {
            return variable.type === 'DEPLOYIT_ENVIRONMENT';
        });
    }

    function collectUsedVariables(variables) {
        return _.filter(variables, function (variable) {
            return variable.used === true;
        });
    }

    return {
        collectUsedVariables: collectUsedVariables,
        hasPackages: hasPackages,
        hasEnvironments: hasEnvironments
    }
}]);
