'use strict';

angular.module('xlrelease').factory('ColorService', ['ReleasesService', 'PhaseColors', function (ReleasesService, PhaseColors) {
    var pastBackgroundColor = '#f1f1f1';

    function desaturate(color) {
        return chroma.interpolate(color, pastBackgroundColor, 0.5).hex();
    }

    return {
        computeDayColor: function (day) {
            if (!day.color) return null;
            return day.dateStatus === 'past' ? desaturate(day.color) : day.color;
        },
        computePhaseColor: function (release, phase) {
            var color = phase.color || PhaseColors[0].value;
            return ReleasesService.isReleaseCompleted(release) ? desaturate(color) : color;
        }
    }
}]);
