angular.module('xlrelease').factory('Backend', ['$http', function($http) {
    var deleteConfig = {
        method: 'DELETE', // IE 8 do not support $http.delete()
        data: null, // Without data, Content-Type is deleted
        headers: {
            'Content-Type': 'application/json' // Without Content-Type, Browser's default Content-Type is used
        }
    };

    return {
        post: function (url, data, config) {
            if (angular.isUndefined(data)) {
                data = {};
            }
            return $http.post(url, data, config);
        },
        get: function (url, config) {
            return $http.get(url, config);
        },
        put: function (url, data, config) {
            if (angular.isUndefined(data)) {
                data = {};
            }
            return $http.put(url, data, config);
        },
        del: function (url, config) {
            var extendedConfig = angular.extend(deleteConfig, config);
            extendedConfig.url = url;

            return $http(extendedConfig);
        }
    };
}]);
