'use strict';

angular.module('xlrelease').controller('templatesController', ['$scope', 'Backend', '$location', 'Authenticator', '$location', function ($scope, Backend, $location) {
    Backend.get('releases/templates').success(function (templates) {
        $scope.templates = templates;
    });

    $scope.deleteTemplate = function (template) {
        Backend.del('releases/templates/' + template.id).success(function () {
            $scope.templates = _.without($scope.templates, template);
        });
    };

    $scope.copyTemplate = function () {
        Backend.post('releases/templates/copy', $scope.templateForm).success(function (releaseView) {
            $scope.templateForm = {};
            $location.path('/templates/' + releaseView.id);
        });
    };

    $scope.displayTemplateEditor = function (template) {
        $location.path('/templates/' + template.id);
    };

    $scope.initTemplateForm = function (template) {
        $scope.templateForm = {
            templateId: template.id,
            title: template.title,
            description: template.description
        };
    };
}]);
