angular.module('xlrelease').filter('taskTypeCssClass', ['lowercaseFilter', function (lowercaseFilter) {
    return function (taskType) {
        // Remove default prefix if any
        taskType = taskType.replace(/^xlrelease\./, '');

        // Replace any '.' with '-'
        taskType = taskType.replace(/\./g, '-');

        // Make everything lowercase
        taskType = lowercaseFilter(taskType);

        return 'task-type-' + taskType;
    }
}]);
