angular.module('xlrelease').directive('displayWithSeparators', function () {
    var DEFAULT_SEPARATOR = '|';
    var SEPARATOR_CLASS = 'separator';
    var separatorElement;

    function removeSeparators(element) {
        element.find('.' + SEPARATOR_CLASS).each(function (index, element) {
            angular.element(element).remove();
        })
    }

    function addSeparatorToVisibles(displayables) {
        var visibles = getVisibles(displayables);
        for(var i = 0; i < visibles.length -1; i++) {
            addSeparator(angular.element(visibles[i].element));
        }
    }

    function getVisibles(displayables) {
        return _.filter(displayables, function (displayable) {
            return displayable.visible;
        });
    }

    function addSeparator(element) {
        element.after(separatorElement);
    }

    return {
        link: function (scope, element, attrs) {
            separatorElement = '<span class="' + SEPARATOR_CLASS + '"> ' + (attrs.displayWithSeparators || DEFAULT_SEPARATOR) + ' </span>';
        },
        controller: ['$scope', '$element', function (scope, element) {
            var displayables = [];
            this.register = function (displayable) {
                displayables.push(displayable);
            };
            this.refresh = function () {
                removeSeparators(element);
                addSeparatorToVisibles(displayables);
            }
        }]
    }
});

angular.module('xlrelease').directive('displayWhen', function () {
    return {
        require: '^displayWithSeparators',
        link: function (scope, element, attrs, displayWithSeparator) {
            var displayable = {
                element: element,
                visible: true
            };

            displayWithSeparator.register(displayable);

            scope.$watch(attrs.displayWhen, function (isVisible) {
                (isVisible) ? element.show() : element.hide();
                displayable.visible = isVisible;
                displayWithSeparator.refresh();
            })
        }
    }
});

